/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */


import opale.mathtools.*;

/**
 * This class provides methods for testing the Bernstein class.
 * Initial version from R.P.
 * @author OpaleTeam
 */
public class TBernstein {

    
    private static void primaryTests(double u) {
	
	System.out.println("\t Proceeding to primary tests");
	System.out.println("\n\t with u = "+u);
	
	System.out.println("\t Output format is B[i][n](u)");
	
	System.out.println("\t Testing B[0][1]("+u+")");
	System.out.println("\t Should be equal to "+(1-u));
	System.out.print("\t Result is :");
	System.out.println(Bernstein.getValue(0,1,u));
	
	System.out.println("\t Testing B[1][1]("+u+")");
	System.out.println("\t Should be equal to "+(u));
	System.out.print("\t Result is :");
	System.out.println(Bernstein.getValue(1,1,u));

	System.out.println("\t Testing B[0][2]("+u+")");
	System.out.println("\t Should be equal to "+(1-u)*(1-u));
	System.out.print("\t Result is :");
	System.out.println(Bernstein.getValue(0,2,u));
	
	System.out.println("\t Testing B[1][2]("+u+")");
	System.out.println("\t Should be equal to "+(1-u)*u*2);
	System.out.print("\t Result is :");
	System.out.println(Bernstein.getValue(1,2,u));
	
	System.out.println("\t Testing B[2][2]("+u+")");
	System.out.println("\t Should be equal to "+(1-u)*u*2);
	System.out.print("\t Result is :");
	System.out.println(Bernstein.getValue(2,2,u));
	
	System.out.println("\n");
    }
    

    private static void testGetValue(int n) {
	
	// u = 0 and for i=0 to 4
	System.out.println("u = 0");
	for(int i = 0; i <= n; i++) {
	    System.out.println("B["+i+"] = "+Bernstein.getValue(i,n,0));
	}
	
	//u = 1 and for i=1 to 4

	// u = 0.125 and for i=1 to 4
    
    }

    private static void testGetValues(double u, int n) {
	
	System.out.println("\n\t Proceeding to getValues' tests");
	System.out.println("\t with u = "+u+"and n = "+n);
	System.out.println("\t Output format is B[i][n](u)");

	double[] results = Bernstein.getAllValues(n,u);
	
	for (int i=0 ; i<=n;i++) {
	    System.out.println("\t B["+i+"]["+n+"]("+u+") = "+results[i]);
	}
    
    }

    public static void main(String args[]) {
	System.out.println("Testing the Bernstein class");
	
	primaryTests(0.0);
	primaryTests(0.5);
	primaryTests(1);
	primaryTests(2);
	
	//testGetValue(2);
	testGetValues(0.125,5);
    
	System.out.println("Test is finished");
    }
}












