/*
 Copyright (c) 1998-2005 The Regents of the University of California
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN  BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY
 *
 */
package diva.canvas.connector;

import diva.canvas.Site;
import diva.canvas.SiteDecorator;

/** A site decorator that disallows changing the normal.  This is useful for
 * perimeter sites that stay at one point on a figure.  Normally connectors
 * change the normal of a site so that the figure looks better.
 * This class is often used so that the site that points out of a terminal
 * can be properly manhattan routed so that it always leave the terminal in
 * the ight direction.
 *
 * @version        $Id: FixedNormalSite.java,v 1.9 2005/07/08 19:54:50 cxh Exp $
 * @author         Steve Neuendorffer
 */
public class FixedNormalSite extends SiteDecorator {
    public FixedNormalSite(Site site) {
        super(site);
    }

    public void setNormal(double normal) {
        // Do nothing
    }
}
