# Test DepthFirstTransformer.
#
# @Author: Thomas Huining Feng
#
# @Version: $Id: Match4Actors.tcl,v 1.2.4.3 2008/03/25 22:12:15 cxh Exp $
#
# @Copyright (c) 1997-2008 The Regents of the University of California.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
#
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
#
#                       PT_COPYRIGHT_VERSION_2
#                       COPYRIGHTENDKEY
#######################################################################

# Ptolemy II test bed, see $PTII/doc/coding/testing.html for more information.

# Load up the test definitions.
if {[string compare test [info procs test]] == 1} then {
    source testDefs.tcl
} {}

######################################################################
####
#
test Match4Actors.1.1 {Test Match4Actors_rule.xml with Match4Actors_1match1.xml} {
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_1match1.xml]
    [$matchResult getMatchResult] toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_1match1.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.gui.Display {.Match4Actors_1match1.Display2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_1match1.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_1match1.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_1match1}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Display2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Display.input}}}

test Match4Actors.1.2 {Test Match4Actors_rule.xml with Match4Actors_1match1.xml (all matches)} {
    set helper [java::new ptolemy.actor.gt.test.AllMatchingTestHelper]
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_1match1.xml [java::field $helper callback]]
    $helper toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_1match1.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.gui.Display {.Match4Actors_1match1.Display2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_1match1.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_1match1.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_1match1}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Display2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_1match1.Display.input}}}

test Match4Actors.2.1 {Test Match4Actors_rule.xml with Match4Actors_2matches2.xml} {
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_2matches2.xml]
    [$matchResult getMatchResult] toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_2matches2.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_2matches2.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_2matches2.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_2matches2.Display2}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_2matches2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Display2.input}}}

test Match4Actors.2.2 {Test Match4Actors_rule.xml with Match4Actors_2matches2.xml (all matches)} {
    set helper [java::new ptolemy.actor.gt.test.AllMatchingTestHelper]
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_2matches2.xml [java::field $helper callback]]
    $helper toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_2matches2.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_2matches2.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_2matches2.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_2matches2.Display2}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_2matches2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Display2.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_2matches2.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_2matches2.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_2matches2.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_2matches2.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_2matches2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_2matches2.Display.input}}}

test Match4Actors.3.1 {Test Match4Actors_rule.xml with Match4Actors_3matches3.xml} {
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_3matches3.xml]
    [$matchResult getMatchResult] toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_3matches3.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_3matches3.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_3matches3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Display3.input}}}

test Match4Actors.3.2 {Test Match4Actors_rule.xml with Match4Actors_3matches3.xml (all matches)} {
    set helper [java::new ptolemy.actor.gt.test.AllMatchingTestHelper]
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_3matches3.xml [java::field $helper callback]]
    $helper toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_3matches3.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_3matches3.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_3matches3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_3matches3.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_3matches3.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_3matches3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_3matches3.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_3matches3.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_3matches3.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_3matches3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_3matches3.Display.input}}}

test Match4Actors.4.1 {Test Match4Actors_rule.xml with Match4Actors_4matches4.xml} {
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_4matches4.xml]
    [$matchResult getMatchResult] toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_4matches4.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_4matches4.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_4matches4}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Display3.input}}}

test Match4Actors.4.2 {Test Match4Actors_rule.xml with Match4Actors_4matches4.xml (all matches)} {
    set helper [java::new ptolemy.actor.gt.test.AllMatchingTestHelper]
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_4matches4.xml [java::field $helper callback]]
    $helper toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_4matches4.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_4matches4.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_4matches4}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_4matches4.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_4matches4.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_4matches4}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_4matches4.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_4matches4.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_4matches4}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_4matches4.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_4matches4.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_4matches4.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_4matches4}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_4matches4.Display.input}}}

test Match4Actors.5.1 {Test Match4Actors_rule.xml with Match4Actors_6matches5.xml} {
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_6matches5.xml]
    [$matchResult getMatchResult] toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display3.input}}}

test Match4Actors.5.2 {Test Match4Actors_rule.xml with Match4Actors_6matches5.xml (all matches)} {
    set helper [java::new ptolemy.actor.gt.test.AllMatchingTestHelper]
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_6matches5.xml [java::field $helper callback]]
    $helper toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_6matches5.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_6matches5.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_6matches5.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_6matches5}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_6matches5.Display3.input}}}

test Match4Actors.6.1 {Test Match4Actors_rule.xml with Match4Actors_8matches6.xml} {
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_8matches6.xml]
    [$matchResult getMatchResult] toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display.input}}}

test Match4Actors.6.2 {Test Match4Actors_rule.xml with Match4Actors_8matches6.xml (all matches)} {
    set helper [java::new ptolemy.actor.gt.test.AllMatchingTestHelper]
    set matchResult [java::call ptolemy.actor.gt.GraphMatcher match Match4Actors_rule.xml Match4Actors_8matches6.xml [java::field $helper callback]]
    $helper toString
} {{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display3.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display.input}}
{ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.A} = ptolemy.actor.lib.Const {.Match4Actors_8matches6.Const}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.B} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue3}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.C} = ptolemy.actor.lib.AbsoluteValue {.Match4Actors_8matches6.AbsoluteValue2}, ptolemy.actor.gt.AtomicActorMatcher {.Match4Actors_rule.Pattern.D} = ptolemy.actor.lib.gui.Display {.Match4Actors_8matches6.Display3}, ptolemy.actor.gt.Pattern {.Match4Actors_rule.Pattern} = ptolemy.actor.TypedCompositeActor {.Match4Actors_8matches6}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output3}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.A.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Const.output2}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.B.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue3.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.input}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.C.criterion2} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.AbsoluteValue2.output}, ptolemy.actor.gt.PortMatcher {.Match4Actors_rule.Pattern.D.criterion1} = ptolemy.actor.TypedIOPort {.Match4Actors_8matches6.Display3.input}}}
