/* Interface of dynamic actors in the CT domain.

 Copyright (c) 1998-2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.domains.ct.kernel;

import ptolemy.actor.Actor;
import ptolemy.kernel.util.IllegalActionException;

//////////////////////////////////////////////////////////////////////////
//// CTDynamicActor

/**
 Interface of dynamic actors in the CT domain. Dynamic actors are actors
 that have one or more integrators. Typically, integrators, analog filters,
 and anything that can be written as<BR>
 dx/dt = f(x, u, t)<BR>
 y = g(x, u, t)<BR>
 are dynamic actors.
 <P>
 There is one method defined in this interface, which is emitCurrentStates().
 This method provides the starting states for an integration and is called
 at the prefireDynamicActors() method of the {@link CTDirector}.

 @author Jie Liu, Haiyang Zheng
 @version $Id: CTDynamicActor.java,v 1.33 2005/07/08 19:57:58 cxh Exp $
 @since Ptolemy II 0.2
 @Pt.ProposedRating Green (hyzheng)
 @Pt.AcceptedRating Green (yuhong)
 */
public interface CTDynamicActor extends Actor {
    /** Implementations of this method should emit the current states of
     *  this actor.
     *  @exception IllegalActionException If the data transfer is not
     *  completed.
     */
    public void emitCurrentStates() throws IllegalActionException;
}
