/* A model for a Ptolemy II object as a node in a diva graph.

 Copyright (c) 1999-2006 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY
 */
package ptolemy.vergil.basic;

import diva.graph.modular.NodeModel;

//////////////////////////////////////////////////////////////////////////
//// NamedObjNodeModel

/**
 A model for a Ptolemy II object as a node in a diva graph.

 @author Steve Neuendorffer and Edward A. Lee
 @version $Id: NamedObjNodeModel.java,v 1.18 2006/03/29 00:02:01 cxh Exp $
 @since Ptolemy II 2.0
 @Pt.ProposedRating Red (yourname)
 @Pt.AcceptedRating Red (reviewmoderator)
 */
public abstract class NamedObjNodeModel implements NodeModel {
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Return a MoML String that will delete the given node from the
     *  Ptolemy model.
     *  @param node The given node to be deleted.
     *  @return A valid MoML string.
     */
    public abstract String getDeleteNodeMoML(Object node);

    /** Remove the specified node from the model.
     *  @param eventSource The event source.
     *  @param node The given node to be deleted.
     */
    public abstract void removeNode(Object eventSource, Object node);
}
