package apps;

import data.*;
import imaging.*;
import tools.*;

/**
 * Converts a NIFTI, ITK or Analyze tensor volume to Camino format. Just does a straight conversion,
 * does not alter the coordinate system of the data. Scaling is applied according to the header,
 * though additional scaling may be applied.
 *  
 * @author Philip Cook
 * @version $Id: DT_ToCamino.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 */
public class DT_ToCamino {

 

    public static void main(String[] args) {
	
	CL_Initializer.inputDataType = "double";

	CL_Initializer.CL_init(args);

	CL_Initializer.initMaskSource();

	// trusting the user to give us a tensor file

	OutputManager om = new OutputManager();

	DataSource tensorSource = null;

	DataSource s0Source = null;

	String s0File = null;

	boolean fileIsLnS0 = false;

	double scaleSlope = 1.0;

	double scaleInter = 0.0;

	// true for ITK, false for NIFTI, undefined for Analyze
	boolean upperTriangular = true;

	for (int i = 0; i < args.length; i++) {
	    if (args[i].equals("-s0")) {
		s0File = args[i+1];
		CL_Initializer.markAsParsed(i,2);
	    }
	    if (args[i].equals("-lns0")) {
		s0File = args[i+1];
		fileIsLnS0 = true;
		CL_Initializer.markAsParsed(i,2);
	    }
	    if (args[i].equals("-scaleslope")) {
		scaleSlope = Double.parseDouble(args[i+1]);
		CL_Initializer.markAsParsed(i,2);
	    } 
	    if (args[i].equals("-scaleinter")) {
		scaleInter = Double.parseDouble(args[i+1]);
		CL_Initializer.markAsParsed(i,2);
	    } 
	    if (args[i].equals("-uppertriangular")) {
		upperTriangular = true;
		CL_Initializer.markAsParsed(i);
	    } 
	    if (args[i].equals("-lowertriangular")) {
		upperTriangular = false;
		CL_Initializer.markAsParsed(i);
	    } 
	    
	}

	CL_Initializer.checkParsing(args);

	// get data
	try {
	   
	    ImageHeader dtHeader = ImageHeader.readHeader(CL_Initializer.inputFile);
	    
	    tensorSource = dtHeader.getImageDataSource();
	}
	catch (java.io.IOException e) {
	    throw new misc.LoggedException(e);
	}


	if (s0File != null) {
	    
	    if (ImageHeader.imageExists(s0File)) {
		try {
		    ImageHeader ih = ImageHeader.readHeader(s0File);
		    s0Source = ih.getImageDataSource();
		}
		catch (java.io.IOException e) {
		    throw new misc.LoggedException(e);
		}
	    }
	    else {
		s0Source = new VoxelOrderDataSource(s0File, 1, CL_Initializer.inputDataType);
	    }
	    
	}

	
	while (tensorSource.more()) {

	    double[] input = tensorSource.nextVoxel();

	    double[] caminoFormat = new double[8];

	    // nifti tensors are in lower-triangular format
	    if (CL_Initializer.bgMask != null) {
		caminoFormat[0] = CL_Initializer.bgMask.nextVoxel()[0] == 0.0 ? -1.0 : 0.0;
	    }
	    

	    if (caminoFormat[0] >= 0.0) {
		if (upperTriangular) {
		    caminoFormat[2] = input[0] * scaleSlope + scaleInter;
		    caminoFormat[3] = input[1] * scaleSlope + scaleInter;
		    caminoFormat[4] = input[2] * scaleSlope + scaleInter;
		    caminoFormat[5] = input[3] * scaleSlope + scaleInter;
		    caminoFormat[6] = input[4] * scaleSlope + scaleInter;
		    caminoFormat[7] = input[5] * scaleSlope + scaleInter;
		}	
		else {
		    caminoFormat[2] = input[0] * scaleSlope + scaleInter;
		    caminoFormat[3] = input[1] * scaleSlope + scaleInter;
		    caminoFormat[4] = input[3] * scaleSlope + scaleInter;
		    caminoFormat[5] = input[2] * scaleSlope + scaleInter;
		    caminoFormat[6] = input[4] * scaleSlope + scaleInter;
		    caminoFormat[7] = input[5] * scaleSlope + scaleInter;
		}

	    }
		
	    if (s0Source != null) {

		double lnS0 = 0.0;

		if (fileIsLnS0) {
		    lnS0 = s0Source.nextVoxel()[0];
		}
		else {
		    double s0 = s0Source.nextVoxel()[0];
		    
		    if (s0 > 0.0) {
			lnS0 = Math.log(s0);
		    }
		}

		if (caminoFormat[0] >= 0.0) {
		    caminoFormat[1] = lnS0;
		}
	    }
		
	    om.output(caminoFormat);
	}

	om.close();
	
    }




}
