package apps;

import tools.CL_Initializer;
import numerics.*;
import data.BallStick;
import data.OutputManager;

/**
 * Outputs a ball and stick model fanning structure
 * 
 * @author Shahrum
 *
 */

public class FanningGrid {

	public static void main(String[] args) {

		/* 
		 * We want as inputs:
		 *  gridsize: dimensions of our grid (units voxel length) 
		 *  gridcentre: vector showing where circle centre is relative to centre of grid
		 *  diffusivity: diffusivity, assumed to be the same in all voxels in the grid
		 *  volfrac: volume fraction of the fibre population, assumed to be the same in all voxels in the grid
		 *   
		 *   */
    
		// initializing command line parameters
		CL_Initializer.CL_init(args);
		CL_Initializer.checkParsing(args);

		double diffusivity = CL_Initializer.DIFF_CONST; //is this wise?
		double volfrac = CL_Initializer.volFrac;
		int[] gridsize = CL_Initializer.dataDims;
		double centreDist = CL_Initializer.centreDist;
		//double[] gridcentre = CL_Initializer.sim_vector;
		
		
		//double[][][][] circleDist = new double[gridsize[0]][gridsize[1]][gridsize[2]][3];
		//double[][][][] circleTangent = new double[gridsize[0]][gridsize[1]][gridsize[2]][3];
		
		
		OutputManager om = new OutputManager();
				
	    for (int k = 0; k < gridsize[2]; k++) {
	    	for (int j = 0; j < gridsize[1]; j++) {
	    		for (int i = 0; i < gridsize[0]; i++) {
	   // 			circleDist[i][j][k] = findCircleDist(i,j,k,gridcentre);
	   // 			circleTangent[i][j][k] = findTangent(circleDist[i][j][k]);
	    			//double[] voxelOrientation = new double[3];
	    			//double[] voxelOrientation = getOrientation(i,j,k,gridsize,centreDist,roll,pitch,yaw);
	    			double[] voxelOrientation = getOrientation(i,j,k,gridsize,centreDist);
	    			BallStick b = new BallStick(diffusivity, volfrac, voxelOrientation);
	    			
	    			double[] informationb = b.getInformationArray();
	    			
	    			double[] fullinformationb = new double[informationb.length+2];
	    			fullinformationb[0]=0;
	    			fullinformationb[1]=0;
	    			for(int ii=2; ii<fullinformationb.length; ii++){
	    				fullinformationb[ii] = informationb[ii-2];
					//				  	System.err.println(fullinformationb[ii]);
	    			}
	    			
	    			om.output(fullinformationb);
	    			
	    		}
	    	}
	    }
	    om.close();
	}
	
	//private static double[] getOrientation(int i, int j, int k, int[] gridsize, double centreDist, double roll, double pitch, double yaw) {
	private static double[] getOrientation(int i, int j, int k, int[] gridsize, double centreDist) {
	    Vector3D p = new Vector3D(-gridsize[0]/2.0+i+0.5, -gridsize[1]/2.0+j+0.5, centreDist-gridsize[2]/2.0+k+0.5);
	    
	    // (PAC) need to check that modulus is not zero (happens with 1x1x1 grid)
	    double mod = p.mod();

	    if (mod > 0.0) {
		double[] r = new double[3];
		r[0] = p.x / mod;
		r[1] = p.y / mod;
		r[2] = p.z / mod;
		return r;
	    }
	    else {
		return new double[] {1.0, 0.0, 0.0};
	    }
	}
	
	
/*	private static double[] findCircleDist(int i, int j, int k, double[] gridcentre) {
		
		double[] pos = new double[3];
		pos[0] = (i) - gridcentre[0];
		pos[1] = (j) - gridcentre[1];
		pos[2] = (k) - gridcentre[2];
		return pos;
	}
	
	private static double[] findTangent(double[] vec) {
        double normconst = vec[0]*vec[0] + vec[1]*vec[1];
        
        double[] ori = new double[3];
        ori[0] = vec[2]/normconst;
        ori[1] = -vec[1]/normconst;
        ori[2] = 0;
        
        return ori;
	}
		
		
*/	
}
