package apps;

import misc.*;
import tools.*;

import java.io.*;
import java.text.*;
import java.util.Locale;

/**
 * Converts Camino scheme files to FSL b-vectors and b-values.
 * 
 * @author Philip Cook
 * @version $Id: SchemeToFSL.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 */
public class SchemeToFSL {


    public static void main(String[] args) {
	
	Locale.setDefault(Locale.UK);

	String bvecfile = null;
	String bvalfile = null;

	String outputRoot = null;

	double diffusionTime = 1.0;

	boolean flipX = false;
	boolean flipY = false;
	boolean flipZ = false;

	double bScale = 1E-6;

	CL_Initializer.CL_init(args);

	for (int i = 0; i < args.length; i++) {
	    if (args[i].equals("-outputroot")) {
		outputRoot = args[i+1];
		CL_Initializer.markAsParsed(i,2);
	    }
	    else if (args[i].equals("-bscale")) {
		bScale = Double.parseDouble(args[i+1]);
		CL_Initializer.markAsParsed(i,2);
	    }
 	    else if (args[i].equals("-flipx")) {
		flipX = true;
		CL_Initializer.markAsParsed(i);
	    }
	    else if (args[i].equals("-flipy")) {
		flipY = true;
		CL_Initializer.markAsParsed(i);
	    }
	    else if (args[i].equals("-flipz")) {
		flipZ = true;
		CL_Initializer.markAsParsed(i);
	    }
	}

	CL_Initializer.checkParsing(args);
	    
	DecimalFormat vecFormat = new DecimalFormat("0.000000");
	DecimalFormat valFormat = new DecimalFormat("0.000");

	try {

	    InputStreamReader isr = null;
	    
	    if (CL_Initializer.inputFile == null) {
		isr = new InputStreamReader(System.in);
	    }
	    else {
		isr = new InputStreamReader(new FileInputStream(CL_Initializer.inputFile));
	    }
	
	    BufferedReader reader = new BufferedReader(isr);
	    
	    double DELTA = Double.parseDouble(reader.readLine());
	    
	    int numQ = Integer.parseInt(reader.readLine());

	    String[] bvecs = new String[] {"", "", ""};

	    String bvals = "";

	    for (int i = 0; i < numQ; i++) {
	    
		double qx = Double.parseDouble(reader.readLine());
		double qy = Double.parseDouble(reader.readLine());
		double qz = Double.parseDouble(reader.readLine());

		double modQ = Math.sqrt(qx*qx + qy*qy + qz*qz);

		bvals += valFormat.format((modQ * modQ * DELTA * bScale)) + " ";

		if (modQ == 0.0) {
		    qx = 1.0;
		}
		else {
		    qx = qx / modQ;
		    qy = qy / modQ;
		    qz = qz / modQ;
		}

		if (flipX && qx != 0.0) {
		    qx = -qx;
		}
		
		
		if (flipY && qy != 0.0) {
		    qy = -qy;
		}
		
		
		if (flipZ && qz != 0.0) {
		    qz = -qz;
		}

		bvecs[0] += vecFormat.format(qx) + " ";
		bvecs[1] += vecFormat.format(qy) + " ";
		bvecs[2] += vecFormat.format(qz) + " ";

	    }

	    reader.close();

	    FileOutput out = new FileOutput(outputRoot + ".bvals");
	    
	    out.writeString(bvals.trim() + "\n");
	    out.close();

	    out = new FileOutput(outputRoot + ".bvecs");
	    out.writeString(bvecs[0] + "\n");
	    out.writeString(bvecs[1] + "\n");
	    out.writeString(bvecs[2] + "\n");
	    out.close();

	}
	catch (IOException e) {
	    throw new LoggedException(e);
	}

	
	

    } 




}
