function image = readImage(varargin)
%
% READIMAGE reads an Analyze, NIFTI-1 or ITK MetaIO image file. 
% Specify the full path to the file including the extension. If no matching image file is found,
% the program appends ".hdr" to the input file name and searches for a matching Analyze image.
% 
% image = READIMAGE(file) returns all volumes in the image. For  
% a 4D image with C components and spatial dimensions X, Y, Z, the 
% returned image dimensions [X][Y][Z][C].
%
% volume = READIMAGE(file, i) reads a 3D volume i in the image, where i is
% indexed from 1. 
% 

ih = javaMethod('readHeader', 'imaging.ImageHeader', varargin{1});

if (nargin == 1)
    image = ih.readVolumeData();
else

    index = varargin{2};

    image = ih.readVolume(index - 1);
end
