package misc;

import numerics.*;

/**
 * Interface for images that compute statistics on the values in each voxel.
 * 
 * @author Philip Cook
 * @version $Id: VoxelwiseStatisticalImage.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *
 */
public interface VoxelwiseStatisticalImage {


    /**
     * Add a value to the voxel (i,j,k).
     *
     */
    public void addValue(int i, int j, int k, double v);


    /**
     *
     * Add a value to the voxel containing the point.
     *
     */
    public void addValue(Point3D p, double v);


    /**
     * Add a value to the voxel (i,j,k), with an associated weight.
     *
     */
    public void addValue(int i, int j, int k, double v, double weight);


    /**
     *
     * Add a value to the voxel containing the point, with an associated weight.
     *
     */
    public void addValue(Point3D p, double v, double weight);


    /**
     * Computes a 3D image, where each voxel intensity is some statistic of the values in the voxel.
     *
     * @param stat a statistic supported by the image.
     */
    public double[][][] getVoxelStatistic(String stat);


}
