package numerics;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Contains implementation of the gamma function.
 * 
 * <dt>Description:
 * 
 * <dd>Adapted from NRC code.
 * 
 * </dl>
 * 
 * @author Danny Alexander $Id: GammaFunctions.java,v 1.3 2005/08/18 11:12:21
 *         ucacmgh Exp $
 *  
 */
public class GammaFunctions {

    /**
     * Euler's constant. (NRC p. 223)
     */
    public static final double EULERGAMMA = 0.5772156649;

    /**
     * The gamma function. See NRC p. 214.
     * 
     * @param xx
     *            Argument at which to evaluate the gamma function.
     */
    public static double gammln(double xx) {
        double x, y, tmp, ser;
        double[] cof = { 76.18009172947146, -86.50532032941677, 24.01409824083091,
                -1.231739572450155, 0.1208650973866179e-2, -0.5395239384953e-5 };
        int j;

        y = x = xx;
        tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        ser = 1.000000000190015;
        for (j = 0; j <= 5; j++)
            ser += cof[j] / ++y;
        return -tmp + Math.log(2.5066282746310005 * ser / x);
    }
}