/* IsoCellularLattice.java created on 28-Nov-2005
 * (simulation)
 * 
 * author: Matt Hall (m.hall@cs.ucl.ac.uk)
 * 
 */
package simulation.geometry;

import simulation.SimulationParams;

/**
 *  Camino fibre reconstruction and tracking toolkit
 * 
 * IsoCellularLattice (simulation)
 * 
 * 
 * 
 *
 * @author Matt Hall (m.hall@cs.ucl.ac.uk)
 *
 */
public class IsoCellularLattice extends CellularLattice {

    
    
    
    
    /** initialises a D dimensional lattice of L cells
     *  each of size l
     * 
     * @param l cell size
     * @param L lattice size
     */
    public IsoCellularLattice(double l, int L, SimulationParams simParams) {
        super(l, L, simParams);
        
        initLattice();
    }
    
    
    /** initialises a completely occupied lattice of cells
     * @see simulation.geometry.CellularLattice#initLattice()
     */
    public void initLattice() {
        for(int i=0; i<occupied.length; i++){
            occupied[i]=true;
        }
    }

    
    
    public static void main(String[] args) {
    }
}
