package tractography;

import numerics.*;

/**
 * 
 * Interface for interpolators.
 *
 * @author Philip Cook
 * @version $Id: ImageInterpolator.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 */
public interface ImageInterpolator {


    /** 
     * Gets tracking direction at some point. The interpolator decides the direction 
     * to follow, and returns it.
     * 
     * @param point the point in mm to interpolate at. 
     * @param previousDirection the direction of the previous tracking step.
     * @return the tracking direction for this point.
     * 
     */
    public Vector3D getTrackingDirection(Point3D point, Vector3D previousDirection);


    /** 
     * Gets the initial tracking direction, given a pdIndex and a seed point.
     *
     * @param point the seed point in mm
     * @param pdIndex the numerical index of the PD to follow, from 0 to (number of PDs) - 1. 
     * @param direction if true, the direction will be the PD, if false, it will be the negated PD.
     * @return the tracking direction for this point. 
     * 
     */
    public Vector3D getTrackingDirection(Point3D point, int pdIndex, boolean direction);



}
