package tractography;

import numerics.*;
import java.util.Random;

/**
 * This class forwards bootstrap PDs, it does not do any randomization of its own.
 *
 * @version $Id $
 * @author  Philip Cook
 * 
 * 
 */
public class PICoBootstrapRandomizer implements PICoRandomizer {

    private final BootstrapTractographyImage image;

    private final Vector3D[][][][] pds;


    /**
     * @param im should be an image that supports bootstrapping.
     *
     */
    public PICoBootstrapRandomizer(BootstrapTractographyImage im) {
        image = im;
        pds = new Vector3D[im.xDataDim()][im.yDataDim()][im.zDataDim()][];
    }

    public Vector3D[] getRandomizedPDs(int i, int j, int k) {
        pds[i][j][k] = image.getPDs(i,j,k);

        return pds[i][j][k];
    }


    /**
     * Evaluates the PDF for a vector at voxel (i,j,k).
     *
     * @param v a unit vector.
     * @param pdIndex the index of the PDF in the voxel.
     * 
     * @return the absolute value of the dot product of the vector with the last bootstrap PD.
     */
    public double pdf(int i, int j, int k, int pdIndex, Vector3D v) {
        
	if (pds[i][j][k][pdIndex] == null) {
	    getRandomizedPDs(i,j,k);
	}
	
        return Math.abs(pds[i][j][k][pdIndex].dot(v));
        
    }

}
