package edu.jhu.bme.smile.commons.math.specialFunctions;

/**
 * @author bennett
 *

 */
public class Legendre 
{
	/**
	 * *	Legendre polynomials can be defined by the following recurrence relations:
	 *
	 *        P0(X)   = 1
	 *        P1(X)   = X
	 *  (k+1) Pk+1(X) = (2k+1) X Pk(X) - k Pk-1(X) 
	 * @param L - degree
	 * @param x - location value
	 * @return P_L(x)
	 */
	public static double val(int L, double x) {
		if(L<=0)
			return 1;
		if(L==1)
			return x;
		double prev2=1;
		double prev=x;
		double current=prev;
		for(int k=2;k<=L;k++) {			
			current = ((2*k)*x*prev-(k-1)*prev2)/k;
			prev2=prev;
			prev=current;
		}
		return current;
	}

	/**
	 * Associated Legendre Polynomials
	 * 
	 * See: http://en.wikipedia.org/wiki/Legendre_function
	 * 
	 * @param L - degree
	 * @param M - order
	 * @param x - location value
	 * @return P^M_L(x)
	 */
	static public double val(int L, int M, double x){
		if(Math.abs(L)<Math.abs(M))
			return 0;
		if(L<0) {
			return val(-L,M,x);			
		}		
		if(M<0) {
			double v = val(L,-M,x);
			return Math.pow(-1, M)*SFunc.factorialratio(L-M,L+M)*v;
		}
		
		// Find P_M^M
		double current; 
		if(M==0)
			current =1;
		else 
			current = Math.pow(-1, M)*SFunc.doubleFactorial(2*M-1)*Math.pow(1-x*x, M/2.);
		//Current is now at L=M, M=M
		
		double last = 0; // P_(M-1)^M = 0; 
		//Now advance the order until L is reached
		
		double next;
		for(int k=M;k<L;k++) {
			next = ((2*k+1)*x*current-(k+M)*last)/(k-M+1); 
			//Next is now P_(k+1)^M
			last = current; 
			current = next; 
		}
		return current;
	}
}