package edu.jhu.bme.smile.demo;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageData;
public class AddingNoise extends ProcessingAlgorithm{
	/*******************************************************
	 * Input Parameters
	 *******************************************************/
	private ParamVolume noise;
	private ParamVolume img;
	
	/*******************************************************
	 * Output Parameters
	 *******************************************************/
	private ParamVolume img_with_noise;
	
	/*******************************************************
	 * CVS
	 *******************************************************/
	private static final String rcsid =
		"$Id: AddingNoise.java,v 1.2 2009/01/13 20:50:32 jhuuser Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");
	
	protected void createInputParameters(ParamCollection inputParams) {
		/**************************************
		 * Plugin Information
		 **************************************/
		inputParams.setName("Adding Noise");
		inputParams.setLabel("Adding Noise");
		inputParams.setCategory("PAMI.demo");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Robert Kim","rkim35@jhu.edu","http://sites.google.com/a/jhu.edu/pami/"));
		info.setDescription("Add a noise to an image.");
		info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
		info.setVersion(revnum);
		/**************************************
		 * Input Initialization
		 **************************************/
		inputParams.add(noise=new ParamVolume("Noise Volume"));
		inputParams.add(img=new ParamVolume("Image Volume"));
	}
	protected void createOutputParameters(ParamCollection outputParams){
		outputParams.add(img_with_noise=new ParamVolume("Image Volume Corrupted with Noise",null,-1,-1,-1,-1));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException{
		ImageData IMG = img.getImageData();
		ImageData NOISE = noise.getImageData();
		//ImageDataMath.addFloatImage(IMG, NOISE);
		//Below code is from edu.jhu.ece.iacl.structures.image.ImageDataMath with some changes.
		int rows=IMG.getRows(), cols=IMG.getCols(), slices=IMG.getSlices(),
		components = IMG.getComponents();
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					for (int l = 0; l < components; l++) {
						double val = IMG.getDouble(i, j, k, l)+NOISE.getDouble(i, j, k, l);				
						if(val<0){
							val=0;
						}
						IMG.set(i,j,k,l,val);						
					}
				}
			}
		}
		img_with_noise.setValue(IMG);
	}

}
