package edu.jhu.bme.smile.demo;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.bme.smile.commons.math.*;
import java.util.ArrayList;
import java.util.List;

public class ScaleImageDemo extends ProcessingAlgorithm{	
	/*******************************************
	 * Input Parameters
	 ******************************************/
	private ParamVolume ParamVol;
	private ParamFloat ParamScale;

	/*******************************************
	 * Output Parameters
	 ******************************************/
	private ParamVolume ParamResult;

	private static final String rcsid =
		"$Id: ScaleImageDemo.java,v 1.2 2009/01/06 14:55:59 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams){
		/**************************************
		 * Plugin Information
		 **************************************/
		inputParams.setName("Demo4: Scale input image");
		inputParams.setLabel("ScaleImage");
		inputParams.setCategory("PAMI.demo");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/a/jhu.edu/pami/"));

		info.setVersion(revnum);
		/***************************************
		 * Creating Inputs
		 ***************************************/
		inputParams.add(ParamVol=new ParamVolume("Input Volume",null,-1,-1,-1,-1));
		inputParams.add(ParamScale=new ParamFloat("Scale"));		
	}

	protected void createOutputParameters(ParamCollection outputParams){
		outputParams.add(ParamResult=new ParamVolume("Result Volume",null,-1,-1,-1,-1));
	}

	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException{

		ImageData img = ParamVol.getImageData();
		ImageDataMath.scaleFloatValue(img, ParamScale.getFloat());
		img.setName(img.getName()+"ScaledBy"+ParamScale.getFloat());
		ParamResult.setValue(img);
	}
}




