package edu.jhu.bme.smile.plugins.nia;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.MipavController;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class NIA4Dto3dFileCollection extends ProcessingAlgorithm{

	private ParamFileCollection in;
	private ParamInteger dim;
	private ParamFileCollection out;
	private ParamOption outputType;
	//	private ParamObject<String> filelist;

	private CubicVolumeReaderWriter readerWriter;

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamFileCollection("Files to Convert",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		inputParams.add(dim=new ParamInteger("Dimension to Extract (3=4th dimension)"));
		dim.setValue(new Integer(3));
		inputParams.setName("4Dto3D");
		inputParams.setPackage("NIA");
		inputParams.setCategory("Utilities.Volume");
		inputParams.setLabel("Convert 4D to 3D");
		readerWriter=new CubicVolumeReaderWriter();
		Vector<String> exts=readerWriter.getExtensionFilter().getExtensions();
		inputParams.add(outputType=new ParamOption("File Type",exts));
		outputType.setValue("img");
	}

	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(out=new ParamFileCollection("Volumes Out",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		//		outputParams.add(filelist=new ParamObject<String>("File List",new StringReaderWriter()));
	}

	protected void execute(CalculationMonitor monitor) {

		
		readerWriter.getExtensionFilter().setPreferredExtension(outputType.getValue());
		String outDir = this.getOutputDirectory().getAbsolutePath();
		File outFile;
		List<File> srcfiles = in.getValue();
		for(File f: srcfiles){
			ImageData vol  = readerWriter.read(f);
			//        for(int k=0; k<vol.getComponents(); k++){
			//          //For a 3d volume, make sure the component is set to 1 and not 0
			//            listout.add(new CubicVolumeMipav("Volume"+k,vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices(),1));
			//        }

			if(dim.getValue().intValue()==3){
				System.out.println(vol.getType());
				for(int l=0; l<Math.max(1,vol.getComponents()); l++){
					String comp = "";
					if(l<10) comp = "0"+l;
					else comp = ""+l;
					if(l<100) comp="0"+comp;
					ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+comp,vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
					for(int i=0;i<vol.getRows();i++){
						for(int j=0;j<vol.getCols();j++){
							for(int k=0;k<vol.getSlices();k++){

								//      					if(vol.get(i, j, k, l).shortValue()!=0){
								//      					System.out.println(vol.get(i, j, k, l));
								//      					}
								nextvol.set(i, j, k, vol.getDouble(i, j, k, l));
							}
						}
					}   
					System.out.println("Completed " +l+"th volume");

					/* Update Header information*/
					ModelImage img=(nextvol).getModelImage();
					FileUtil.updateFileInfo(vol.getModelImage(),img);
					img.calcMinMax();
					outFile=new File(outDir);
					File next = readerWriter.write(nextvol, outFile);					
					out.add(next);
					nextvol.dispose();
					nextvol=null;
				}
			}else if(dim.getValue().intValue()==2){
				System.out.println(vol.getType());
				for(int l=0; l<Math.max(1,vol.getSlices()); l++){
					//        	for(int l=86; l<88; l++){
					String comp = "";
					if(l<10) comp = "0"+l;
					else comp = ""+l;
					if(l<100) comp="0"+comp;
					ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+comp,vol.getType(),vol.getRows(), vol.getCols(), vol.getComponents());
					for(int i=0;i<vol.getRows();i++){
						for(int j=0;j<vol.getCols();j++){
							for(int k=0;k<vol.getComponents();k++){

								nextvol.set(i, j, k, vol.getDouble(i, j, l, k));
							}
						}
					}   
					System.out.println("Completed " +l+"th volume");
					/* Update Header information*/
					ModelImage img=(nextvol).getModelImage();
					FileUtil.updateFileInfo(vol.getModelImage(),img);
					img.calcMinMax();

					outFile=new File(outDir );
					File next = readerWriter.write(nextvol, outFile);					
					out.add(next);
					nextvol.dispose();
					nextvol=null;
				}
			}else if(dim.getValue().intValue()==1){
				System.out.println(vol.getType());
				for(int l=0; l<Math.max(1,vol.getCols()); l++){
					String comp = "";
					if(l<10) comp = "0"+l;
					else comp = ""+l;
					if(l<100) comp="0"+comp;
					ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+comp,vol.getType(),vol.getRows(), vol.getSlices(), vol.getComponents());
					for(int i=0;i<vol.getRows();i++){
						for(int j=0;j<vol.getSlices();j++){
							for(int k=0;k<vol.getComponents();k++){

								//      					if(vol.get(i, j, k, l).shortValue()!=0){
								//      					System.out.println(vol.get(i, j, k, l));
								//      					}
								nextvol.set(i, j, k, vol.getDouble(i, l, j, k));
							}
						}
					}   
					System.out.println("Completed " +l+"th volume");
					/* Update Header information*/
					ModelImage img=(nextvol).getModelImage();
					FileUtil.updateFileInfo(vol.getModelImage(),img);
					img.calcMinMax();

					outFile=new File(outDir );
					File next = readerWriter.write(nextvol, outFile);					
					out.add(next);
					nextvol.dispose();
					nextvol=null;
				}
			}
			else if(dim.getValue().intValue()==0){
				System.out.println(vol.getType());
				for(int l=0; l<Math.max(1,vol.getRows()); l++){
					String comp = "";
					if(l<10) comp = "0"+l;
					else comp = ""+l;
					if(l<100) comp="0"+comp;
					ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+comp,vol.getType(),vol.getCols(), vol.getSlices(), vol.getComponents());
					for(int i=0;i<vol.getCols();i++){
						for(int j=0;j<vol.getSlices();j++){
							for(int k=0;k<vol.getComponents();k++){

								//      					if(vol.get(i, j, k, l).shortValue()!=0){
								//      					System.out.println(vol.get(i, j, k, l));
								//      					}
								nextvol.set(i, j, k, vol.getDouble(l, i, j, k));
							}
						}
					}   
					System.out.println("Completed " +l+"th volume");
					/* Update Header information*/
					ModelImage img=(nextvol).getModelImage();
					FileUtil.updateFileInfo(vol.getModelImage(),img);
					img.calcMinMax();

					outFile=new File(outDir );
					File next = readerWriter.write(nextvol, outFile);							
					out.add(next);
					nextvol.dispose();
					nextvol=null;
				}

			}
			//			MipavController.getImageByName(vol.getName());
			//			MipavController.removeFromReigstry(vol.getModelImage());
			//			MipavController.
			//			vol.getModelImage().disposeLocal();
			vol.dispose();
			vol=null;

		}
		//		listout.trimToSize();
		//		out.setValue(listout);			

		//Specify the object for the output file
		//		filelist.setObject("FileList");
		//specify the file name for the output file
		//		filelist.setFileName("filelist.txt");
		


	}


}
