package edu.jhu.ece.iacl.algorithms.dti.tractography.FACT;

public class RunFACT {

	/**
	 * FA file
	 * VEC file
	 * Parameter file
	 */
	
	public static void main(String[] args) {
		
//		String faname = args[0];
//		String vecname = args[1];
//		String paramname = args[2];
		
//		String subname = "ac_15";
//		String dirname = "/home/john/Research/20070727/corrected_dti/processed/ac_15/";
//		String faname = dirname + subname+".fa";
//		String vecname = dirname + subname+".vec";
//		String paramname = "/home/john/Research/20070727/FACT/FACTparam3 .txt";
		
//		String faname = "/iacl/cruise07/bennett/projects/CSdeconv/data2/dti/RDR1_20080313_cerebellum_3_1_sc.fa";
//		String vecname= "/iacl/cruise07/bennett/projects/CSdeconv/data/FLT1_at1085_A_3_1_sc1.vec";
//		String vecname= "/iacl/cruise07/bennett/projects/CSdeconv/data2/dti/RDR1_20080313_cerebellum_3_1_sc.vec";
		
		String faname = "/home/john/Research/DTIcompressedSensing/RDR1_20080313_cerebellum_3_1_sc.fa";
		String vecname = "/home/john/Research/DTIcompressedSensing/RDR1_20080313_cerebellum_3_1_sc.vec";
			
		String paramname = "/home/john/Research/20070727/FACT/FACTparam2.txt";
			
//		String fiberfile = "/home/john/Research/DTIcompressedSensing/ac_15_iaclTEST.dat";
		
		
		int x = 107;
		int y = 124;
		int z = 36;
		
		System.out.println(faname);
		System.out.println(vecname);
		System.out.println(paramname);
//		System.out.println(fiberfile);
		
		long start = System.currentTimeMillis();
		System.out.println("Running...");
		
//		/home/john/Resarch/dti_cruise/factparamtest.txt
		
		FACTapi ftracker = new FACTapi();
		ftracker.dataConfig.setDefaultParameters();
		System.out.println("Reading Parameters: " + paramname);
		ftracker.readParamFile(paramname);
		
		System.out.println("Loading files...");
	    ftracker.loadData(faname,vecname,
	    		ftracker.dataConfig.Nx,ftracker.dataConfig.Ny,ftracker.dataConfig.Nz,
	    		ftracker.dataConfig.resX,ftracker.dataConfig.resY,ftracker.dataConfig.resZ);
	    System.out.println("Finished Loading!");
	    long data = System.currentTimeMillis();
	    
	    System.out.println("Fiber Tracking...");
//	    ftracker.trackAllFibers();
	    ftracker.trackFromSeed(x, y, z);
	    System.out.println("Finished Tracking!");
	    long track= System.currentTimeMillis();
        System.out.println("Complete: "+((data-start)/10)/100f+" s to load data, "+((track-data)/10)/100f+" s to track fibers");

        
        if(ftracker.allFibers!=null){
        	System.out.println("Writing Fibers...");
//        	String fiberfile = faname.substring(0, faname.lastIndexOf(".")) + "_FACTfibsTEST.vtk";
        	String fiberfile = "/home/john/Research/DTIcompressedSensing/FACTvsINFACT/FACT_"+x+"_"+y+"_"+z+".vtk";
        	System.out.println(fiberfile);
        	ftracker.writeFibersVTK(fiberfile);
        	
        	System.out.println("Finished Writing!");
        }
	    
		System.out.println("Done!");
		

	}

}
