package edu.jhu.ece.iacl.plugins.dti;
/* This plugin does not compile - in development - only checked
 * in because build path became corrupt.
 */
import imaging.Scheme;
import imaging.SchemeV1;
import inverters.AlgebraicDT_Inversion;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearDT_Inversion;
import inverters.ModelIndex;
import inverters.NonLinearDT_Inversion;
import inverters.RestoreDT_Inversion;
import inverters.TensorModelFitter;
import inverters.TwoTensorInversion;
import inverters.WeightedLinearDT_Inversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.thoughtworks.xstream.XStream;

import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.algorithms.dti.EstimateTensorLLMSE;
import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.*;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.plugins.dti.DWITensorEstCaminoFileCollection.TensorEstimationWrapper;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class DWITwoTensorEstCaminoFileCollection extends ProcessingAlgorithm{ 

	/****************************************************
	 * Input Parameters 
	 ****************************************************/
	private ParamFileCollection DWdata4D; 		// Imaging Data
	private ParamFileCollection Mask3D;			// Binary mask to indicate computation volume
	private ParamOption twoTensorFitOption;		// Option to attempt to estimate with missing data
	private ParamOption oneTensorInitOption;		// Option to attempt to estimate with missing data
	private ParamFloat noiseLevel;		// Used for restore
	private ParamFile SchemeFile;
	/****************************************************
	 * Output Parameters
	 ****************************************************/
	private ParamFileCollection tensor1Volume;	// A 4D volume with one tensor estimated per pixel
	private ParamFileCollection tensor2Volume;	// A 4D volume with one tensor estimated per pixel
	private ParamFileCollection mix1Volume;	// A 3D volume with the mixture component of tensor 1
	private ParamFileCollection mix2Volume;	// A 3D volume with the mixture component of tensor 2
	private ParamFileCollection exitCodeVolume;	// A 3D volume 
	private ParamFileCollection intensityVolume;// A 3D volume 
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: DWITwoTensorEstCaminoFileCollection.java,v 1.1 2009/03/27 01:28:44 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {

		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setName("Two Tensor Estimation Camino (v2)");
		inputParams.setLabel("Double Tensor Est");	
		inputParams.setCategory("Modeling.Diffusion");
		inputParams.setPackage("Camino");		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/site/bennettlandman/"));
		info.setDescription("Log-linear minium mean squared error tensor estimation.");
		info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
		info.add(new Citation("Landman BA, Farrell JA, Jones CK, Smith SA, Prince JL, Mori S. Effects of diffusion weighting schemes on the reproducibility of DTI-derived fractional anisotropy, mean diffusivity, and principal eigenvector measurements at 1.5T. Neuroimage 2007;36(4):1123-1138."));
		info.add(new Citation("Basser, PJ, Jones, DK. \"Diffusion-tensor MRI: Theory, experimental design and data analysis - a technical review.\" NMR Biomed 2002; 15(7-8):456-67"));		
		info.setVersion(revnum);	


		/****************************************************
		 * Step 2. Add input parameters to control system 
		 ****************************************************/
		inputParams.add(DWdata4D=new ParamFileCollection("DWI and Reference Image(s) Data (4D)",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		inputParams.add(SchemeFile=new ParamFile("CAMINO DTI Description (SchemeV1)",new FileExtensionFilter(new String[]{"scheme","schemev1"})));
		//		inputParams.add(gradsTable=new ParamFile("Table of diffusion weighting directions",new FileExtensionFilter(new String[]{"grad","dpf"})));
		//		inputParams.add(bvaluesTable=new ParamFile("Table of b-values",new FileExtensionFilter(new String[]{"b"})));
		inputParams.add(Mask3D=new ParamFileCollection("Mask Volume to Determine Region of Tensor Estimation (3D)",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		Mask3D.setMandatory(false); // Not required. A null mask will estimate all voxels.
		inputParams.add(twoTensorFitOption=new ParamOption("Two-Tensor Model Fitter",
				new String[]{"Cylindrically Symmetric","Cylindrically Symmetric (equal fraction)","Both Positive Definite","Both Positive Definite (equal fraction)","Pos. Def. + Cyl. Sym.","Pos. Def. + Cyl. Sym. (equal fraction)"}));
		twoTensorFitOption.setValue("Both Positive Definite");
		inputParams.add(oneTensorInitOption=new ParamOption("One-Tensor Initialization",new String[]{"Algebraic","Linear","NonLinear","RESTORE","WeightedLinear"}));
		oneTensorInitOption.setValue("Linear");

		inputParams.add(noiseLevel=new ParamFloat("Noise Level (RESTORE only)"));
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		/****************************************************
		 * Step 1. Add output parameters to control system 
		 ****************************************************/
		mix1Volume = new ParamFileCollection("Mixture Fraction of Tensor 1",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		mix1Volume.setName("Mixture Fraction for Tensor 1");
		outputParams.add(mix1Volume);
		tensor1Volume = new ParamFileCollection("First Tensor Estimate",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		tensor1Volume.setName("Tensor 1 (xx,xy,xz,yy,yz,zz)");
		outputParams.add(tensor1Volume);
		mix2Volume = new ParamFileCollection("Mixture Fraction of Tensor 2",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		mix2Volume.setName("Mixture Fraction for Tensor 2");
		outputParams.add(mix2Volume);
		tensor2Volume = new ParamFileCollection("Second Tensor Estimate",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		tensor2Volume.setName("Tensor 2 (xx,xy,xz,yy,yz,zz)");
		outputParams.add(tensor2Volume);
		exitCodeVolume = new ParamFileCollection("Estimation Exit Code",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		exitCodeVolume.setName("Exit Code");
		outputParams.add(exitCodeVolume);	
		intensityVolume = new ParamFileCollection("Intensity Estimate",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions));
		intensityVolume.setName("Intensity");
		outputParams.add(intensityVolume);

	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {		
		TensorEstimationWrapper wrapper=new TensorEstimationWrapper();
		monitor.observe(wrapper);
		wrapper.execute();
	}

	protected class TensorEstimationWrapper extends AbstractCalculation {

		protected void execute() {
			/****************************************************
			 * Step 1. Indicate that the plugin has started.
			 * 		 	Tip: Use limited System.out.println statements
			 * 			to allow end users to monitor the status of
			 * 			your program and report potential problems/bugs
			 * 			along with information that will allow you to 
			 * 			know when the bug happened.  
			 ****************************************************/
			System.out.println("DWITensorEstLLMSE: Start");

			/****************************************************
			 * Step 2. Loop over input slabs
			 ****************************************************/
			List<File> dwList = DWdata4D.getValue();
			List<File> maskList = Mask3D.getValue();
			CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance();
			ArrayList<File> outTensor1Vols = new ArrayList<File>();
			ArrayList<File> outTensor2Vols = new ArrayList<File>();
			ArrayList<File> outMix1Vols = new ArrayList<File>();
			ArrayList<File> outMix2Vols = new ArrayList<File>();
			ArrayList<File> outExitVols = new ArrayList<File>();
			ArrayList<File> outIntensityVols = new ArrayList<File>();
			this.addTotalUnits(dwList.size());
			for(int jSlab=0;jSlab<dwList.size();jSlab++) {
				/****************************************************
				 * Step 2. Parse the input data 
				 ****************************************************/
				System.out.println("Load data.");System.out.flush();
				this.setLabel("Load");
				ImageData dwd=rw.read(dwList.get(jSlab));//DWdata4D.getImageData();
				String imageName = dwd.getName();
				ImageDataFloat DWFloat=new ImageDataFloat(dwd);dwd.dispose();

				ImageData maskVol=null;
				if(maskList.size()>jSlab)
					maskVol=rw.read(maskList.get(jSlab));
				byte [][][]mask=null;
				if(maskVol!=null) {
					ImageDataUByte maskByte = new ImageDataUByte (maskVol);
					mask = maskByte.toArray3d();
					maskVol.dispose(); maskVol=null;
					maskByte.dispose(); maskByte=null;
				}

				System.out.println("Load scheme.");System.out.flush();
				setLabel("Load scheme");
				SchemeV1 DTIscheme = null;

				XStream xstream = new XStream();
				xstream.alias("CaminoDWScheme-V1",imaging.SchemeV1.class);
				try {
					ObjectInputStream in = xstream.createObjectInputStream(new FileReader(SchemeFile.getValue()));
					DTIscheme=(SchemeV1)in.readObject();
					in.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					throw new RuntimeException(e);
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					throw new RuntimeException(e);
				}


				/****************************************************
				 * Step 3. Perform limited error checking 
				 ****************************************************/
				System.out.println("Error checking."); System.out.flush();

				TwoTensorInversion dtiFit=null;
				String code = "";

				ModelIndex twoTensorModelIndex=twoTensorModelIndex=ModelIndex.POSPOS;; 
				ModelIndex oneTensorModelIndex=ModelIndex.LDT;

				if(oneTensorInitOption.getValue().compareToIgnoreCase("Algebraic")==0) {
					oneTensorModelIndex=ModelIndex.ALGDT;
					code = "ALGDT";
				}
				if(oneTensorInitOption.getValue().compareToIgnoreCase("Linear")==0) {
					oneTensorModelIndex=ModelIndex.LDT;
					code = "LDT";
				}
				if(oneTensorInitOption.getValue().compareToIgnoreCase("NonLinear")==0) {
					oneTensorModelIndex=ModelIndex.NLDT;
					code = "NLDT";
				}
				if(oneTensorInitOption.getValue().compareToIgnoreCase("RESTORE")==0) {
					oneTensorModelIndex=ModelIndex.RESTORE;
					code = "RESTORE";
				}
				if(oneTensorInitOption.getValue().compareToIgnoreCase("WeightedLinear")==0) {
					oneTensorModelIndex=ModelIndex.LDT_WTD;
					code = "WLDT";
				}


				if(twoTensorFitOption.getValue().compareToIgnoreCase("Cylindrically Symmetric")==0) {
					twoTensorModelIndex=ModelIndex.CYLCYL;
					code = code+"CYLCYL";
				}
				if(twoTensorFitOption.getValue().compareToIgnoreCase("Cylindrically Symmetric (equal fraction)")==0) {
					twoTensorModelIndex=ModelIndex.CYLCYL_EQ;
					code = code+"CYLCYLEQ";
				}
				if(twoTensorFitOption.getValue().compareToIgnoreCase("Both Positive Definite")==0) {
					twoTensorModelIndex=ModelIndex.POSPOS;
					code = code+"POSPOS";
				}
				if(twoTensorFitOption.getValue().compareToIgnoreCase("Both Positive Definite (equal fraction)")==0) {
					twoTensorModelIndex=ModelIndex.POSPOS_EQ;
					code = code+"POSPOSEQ";
				}
				if(twoTensorFitOption.getValue().compareToIgnoreCase("Pos. Def. + Cyl. Sym.")==0) {
					twoTensorModelIndex=ModelIndex.POSCYL;
					code = code+"POSCYL";
				}
				if(twoTensorFitOption.getValue().compareToIgnoreCase("Pos. Def. + Cyl. Sym. (equal fraction)")==0) {
					twoTensorModelIndex=ModelIndex.POSCYL_EQ;
					code = code+"POSCYLEQ";
				}
				dtiFit=new TwoTensorInversion(DTIscheme,twoTensorModelIndex,oneTensorModelIndex);
				/****************************************************
				 * Step 4. Run the core algorithm. Note that this program 
				 * 		   has NO knowledge of the MIPAV data structure and 
				 * 		   uses NO MIPAV specific components. This dramatic 
				 * 		   separation is a bit inefficient, but it dramatically 
				 * 		   lower the barriers to code re-use in other applications.  		  
				 ****************************************************/
				System.out.println("Allocate memory."); System.out.flush();
				setLabel("Allocate");
				float [][][][]data=DWFloat.toArray4d();
				int rows = data.length;
				int cols= data[0].length;
				int slices= data[0][0].length;
				int components= data[0][0][0].length;
				float [][][][]mix1 = new float[rows][cols][slices][1];
				float [][][][]tensors1 = new float[rows][cols][slices][6];
				float [][][][]mix2 = new float[rows][cols][slices][1];
				float [][][][]tensors2 = new float[rows][cols][slices][6];
				float [][][][]exitCode= new float[rows][cols][slices][1];
				float [][][][]intensity= new float[rows][cols][slices][1];


				System.out.println("Run CAMINO estimate."); System.out.flush();
				setLabel("Estimate");
				EstimateTensorLLMSE.estimateCaminoTwoTensor(data,mask,dtiFit,mix1,tensors1,mix2,tensors2,exitCode,intensity);

				/****************************************************
				 * Step 5. Retrieve the image data and put it into a new
				 * 			data structure. Be sure to update the file information
				 * 			so that the resulting image has the correct
				 * 		 	field of view, resolution, etc.  
				 ****************************************************/
				System.out.println("Data export."); System.out.flush();
				setLabel("Export");
				ImageDataFloat out=new ImageDataFloat(tensors1);
				out.setHeader(DWFloat.getHeader());
				out.setName(imageName+"_Tensor1"+code);
				File outputSlab = rw.write(out, getOutputDirectory());			
				outTensor1Vols.add(outputSlab);
				
				out=new ImageDataFloat(tensors2);
				out.setHeader(DWFloat.getHeader());
				out.setName(imageName+"_Tensor2"+code);
				outputSlab = rw.write(out, getOutputDirectory());			
				outTensor2Vols.add(outputSlab);
								

				out=new ImageDataFloat(mix1);
				out.setHeader(DWFloat.getHeader());
				out.setName(imageName+"_Mix1"+code);
				outputSlab = rw.write(out, getOutputDirectory());			
				outMix1Vols.add(outputSlab);
				
				out=new ImageDataFloat(mix2);
				out.setHeader(DWFloat.getHeader());
				out.setName(imageName+"_Mix2"+code);
				outputSlab = rw.write(out, getOutputDirectory());			
				outMix2Vols.add(outputSlab);

				out=new ImageDataFloat(exitCode);
				out.setHeader(DWFloat.getHeader());
				out.setName(imageName+"_ExitCode"+code);
				outputSlab = rw.write(out, getOutputDirectory());
				outExitVols.add(outputSlab);
				System.out.println(outputSlab);System.out.flush();

				out=new ImageDataFloat(intensity);
				out.setHeader(DWFloat.getHeader());
				out.setName(imageName+"_Intensity"+code);					
				outputSlab = rw.write(out, getOutputDirectory());
				outIntensityVols.add(outputSlab);
				
				/****************************************************
				 * Step 6. Let the user know that your code is finished.  
				 ****************************************************/
				System.out.println("DWITensorEstLLMSE: FINISHED");
				this.incrementCompletedUnits();
			}
			tensor1Volume.setValue(outTensor1Vols);
			tensor2Volume.setValue(outTensor2Vols);
			mix1Volume.setValue(outMix1Vols);
			mix2Volume.setValue(outMix2Vols);
			exitCodeVolume.setValue(outExitVols);
			intensityVolume.setValue(outIntensityVols);
		}
	}
}
