package edu.jhu.ece.iacl.plugins.dti;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

public class MedicAlgorithmFormatVectorImage extends ProcessingAlgorithm{
	
	//input params
	private ParamVolume vecvolin;
	private ParamOption format;
	
	//output param
	private ParamVolume vecvolout;
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(vecvolin = new ParamVolume("Input Vector Volume",null,-1,-1,-1,-1));
		String[] flipoptions = {"3xNxMxL to NxMxLx3","NxMxLx3 to 3xMxNxL"};
		inputParams.add(format = new ParamOption("Volume Format",flipoptions));
		inputParams.setCategory("IACL.DTI");
		inputParams.setName("VectorVolFormat");
		inputParams.setLabel("Format Vector Volume");
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {		
		outputParams.add(vecvolout = new ParamVolume("Formated Vector Volume",null,-1,-1,-1,-1));
	}
	
	protected void execute(CalculationMonitor monitor) {

		ImageDataMipav vol = vecvolin.getImageData();
		ImageDataMipav volout;
		if(format.getIndex()==0){
			if(vol.getRows()==3){
				volout = new ImageDataMipav(vol.getName()+"_"+format.getValue(), 
						vol.getType(), vol.getCols(), vol.getSlices(), vol.getComponents(), vol.getRows());
				
				for(int i=0;i<vol.getRows();i++){
					for(int j=0;j<vol.getCols();j++){
						for(int k=0;k<vol.getSlices();k++){
							for(int l=0;l<vol.getComponents();l++){
								volout.set(j,k,l,i,vol.getFloat(i,j,k,l));
							}
						}
					}
				}   
			}else{
				volout = vol;
			}
		}else{
			if(vol.getComponents()==3){
				volout = new ImageDataMipav(vol.getName()+"_"+format.getValue(), 
						vol.getType(), vol.getComponents(), vol.getRows(), vol.getCols(), vol.getSlices());
				for(int i=0;i<vol.getRows();i++){
					for(int j=0;j<vol.getCols();j++){
						for(int k=0;k<vol.getSlices();k++){
							for(int l=0;l<vol.getComponents();l++){
								volout.set(l,i,j,k,vol.getFloat(i,j,k,l));
							}
						}
					}
				}   
			}else{
				volout = vol;
			}
		}

		vecvolout.setValue(volout);
	}

}
