package edu.jhu.ece.iacl.plugins.dti;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

public class MedicAlgorithmTensorFormatConvert extends ProcessingAlgorithm{

	private ParamVolume in;
	private ParamBoolean dir;
	private ParamVolume out;
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("Mult-Component Volume",null,-1,-1,-1,6));
		inputParams.add(dir=new ParamBoolean("Medic to IACL", true));
		inputParams.setName("tensorformatconvert");
		inputParams.setCategory("IACL.DTI");
		inputParams.setLabel("Tensor Format Converter");
	}
	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(out=new ParamVolume("Volume Out",null,-1,-1,-1,6));
	}
	
	protected void execute(CalculationMonitor monitor) {
	
        ImageDataMipav vol = in.getImageData();
        ImageDataMipav volout = vol.mimic();
        
        int[] map = null;
        if(dir.getValue()){
        	map = new int[]{0,3,4,1,5,2};
        }else{
        	map = new int[]{0,3,5,1,2,4};
        }
        
        for(int l=0;l<vol.getComponents();l++){
        	for(int i=0; i<vol.getRows(); i++){
        		for(int j=0;j<vol.getCols();j++){
        			for(int k=0;k<vol.getSlices();k++){
        				volout.set(i, j, k,l, vol.getDouble(i, j,k, map[l]));
        			}
        		}
        	}   
        }
        out.setValue(volout);
		
	}
	

}
