package edu.jhu.ece.iacl.plugins.dti;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.bme.smile.commons.math.StatisticsDouble;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.bme.smile.commons.math.*;
/**
 * public class ChebyShevFitting
 * 
 * This plugin performs ChebyShev polynomial fitting on an input data set.
 * 
 * @author Robert Kim
 *
 */
public class RegularizeNoiseField extends ProcessingAlgorithm{
	/**
	 * Input Parameters
	 * ParamVolume img - Image volume upon which Chebyshev polynomial fitting will be applied.
	 * ParamInteger degX - the number of degrees of freedom in the polynomial for the x (1st) dimension
	 * ParamInteger degY - the number of degrees of freedom in the polynomial for the y (2nd) dimension
	 */	
	private ParamVolume img;
	private ParamInteger degX;
	private ParamInteger degY;
	private ParamVolume weights;
	private ParamBoolean applyMask;

	/**
	 * Output Parameters
	 * ParamVolume result - Result image volume after Chebyshev polynomial fitting
	 */
	private ParamVolume result;

	/**
	 * CVS
	 */
	private static final String rcsid =
		"$Id: RegularizeNoiseField.java,v 1.2 2009/02/05 12:54:53 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {
		/**
		 * Plugin Information
		 */
		inputParams.setName("Regularize Noise Field");
		inputParams.setLabel("Regularize Noise Field");
		inputParams.setCategory("Modeling.Noise");
		inputParams.setPackage("IACL");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/a/jhu.edu/pami/"));
		info.add(new AlgorithmAuthor("Robert Kim","rkim35@jhu.edu","http://sites.google.com/a/jhu.edu/pami/"));
		info.setDescription("Chebyshev polynomial fitting on an image volume.");
		info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
		info.setVersion(revnum);
		/**
		 * Input Initialization
		 */
		inputParams.add(img=new ParamVolume("Image for Chebyshev Fitting"));
		inputParams.add(weights=new ParamVolume("Corresponding importance weightings"));
		weights.setMandatory(false);
		inputParams.add(applyMask=new ParamBoolean("Mask Noise Field",true));
		inputParams.add(degX=new ParamInteger("Degrees of Freedom for x"));
		degX.setValue(new Integer(3));
		inputParams.add(degY=new ParamInteger("Degrees of Freedom for y"));
		degY.setValue(new Integer(3));
	}
	protected void createOutputParameters(ParamCollection outputParams){
		outputParams.add(result=new ParamVolume("Image Volume After Chebyshev Fitting",null,-1,-1,-1,-1));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException{
		System.out.println("RegularizeNoiseField:Started"); System.out.flush();
		ImageData IMG = img.getImageData();
		ImageData wt = weights.getImageData();

		int DEG_X = degX.getInt();
		int DEG_Y = degY.getInt();
		int rows=IMG.getRows(), cols=IMG.getCols(), slices=IMG.getSlices(),
		components = IMG.getComponents();
		if(slices<1) slices=1;
		if(components<1) components=1;
		ImageData out = new ImageDataFloat(IMG);		
		out.setName("After Fitting");
		float[][]tmp = new float[rows][cols];
		float[][]rst = new float[rows][cols];
		float [][]WT = new float[rows][cols];
		for(int p=0;p<components;p++){
			for(int q=0;q<slices;q++)
			{
				for(int i=0;i<rows;i++)
				{
					for(int j=0;j<cols;j++)
					{
						tmp[i][j] = IMG.getFloat(i, j, q,p);
						if(tmp[i][j]<=0)
							tmp[i][j]=Float.NaN;
					}
				}
				System.out.println("RegularizeNoiseField:Slice "+q); System.out.flush();
				if(wt==null) {
					rst = FieldRegularize.regularize2DChebyshev(DEG_X, DEG_Y, tmp);
				} else {
					int cnt =0;
					for(int i=0;i<rows;i++)
					{
						for(int j=0;j<cols;j++)
						{
							WT[i][j] = wt.getFloat(i, j, q,p);
							if(!(Double.isInfinite(WT[i][j])||Double.isNaN(WT[i][j])||WT[i][j]<=0))
								cnt++;
							else
								tmp[i][j]=Float.NaN;
						}
					}
					System.out.println(cnt);System.out.flush();

					//					rst = FieldRegularize.regularize2DChebyshevWLS(DEG_X, DEG_Y, tmp,WT);
					//					rst = FieldRegularize.regularize2DChebyshev(DEG_X, DEG_Y, tmp);
					rst = FieldRegularize.regularize2DChebyshevWLS(DEG_X, DEG_Y, tmp,WT);				
				}

				for(int i=0;i<rows;i++)
				{
					for(int j=0;j<cols;j++)
					{
						out.set(i,j,q,p,(rst[i][j]));		
					}
				}	

			}	
		}				
		result.setValue(out);
		System.out.println("RegularizeNoiseField:Done"); System.out.flush();

	}
}
