package edu.jhu.ece.iacl.plugins.dti.tractography;

import java.util.ArrayList;


import edu.jhu.ece.iacl.algorithms.dti.tractography.FiberStatistics;
import edu.jhu.ece.iacl.io.ArrayDoubleListTxtReaderWriter;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.io.FiberCollectionReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;

public class Fiber2Volume extends ProcessingAlgorithm{
	
	//output params
	private ParamVolume fibervol;
	
	//input params
	private ParamObject<FiberCollection> fibers;
	private ParamVolume tempvol;
	
	private ParamOption statoi; //statistic of interest
	
	
	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.add(fibers=new ParamObject<FiberCollection>("Fibers", new FiberCollectionReaderWriter()));
		inputParams.add(tempvol = new ParamVolume("DataVolume",null,-1,-1,-1,-1));
		
		String[] stats = {"Count","Mask"};
		inputParams.add(statoi = new ParamOption("Statistic of Interst",stats));
		inputParams.setCategory("IACL.DTI.Fiber");
		inputParams.setName("fiber2volume");
		inputParams.setLabel("Fibers To Volume");
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
//		dwiMotionCorr = new ParamVolumeCollection("Output Diffusion-weighted Volumes");
		fibervol = new ParamVolume("Fiber Volume",null,-1,-1,-1,1);
		outputParams.add(fibervol);
	}
	
	protected void execute(CalculationMonitor monitor) {

		FiberStatistics fs = new FiberStatistics(fibers.getObject());
		fibervol.setValue(fs.fibers2Volume(statoi.getValue(), tempvol.getImageData()));
	
	}

}
