package edu.jhu.ece.iacl.plugins.dti.tractography;

import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.vecmath.Point3d;

import edu.jhu.ece.iacl.algorithms.dti.tractography.FiberStatistics;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.io.CurveVtkReaderWriter;
import edu.jhu.ece.iacl.io.FiberCollectionReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.structures.geom.CurveCollection;

public class MedicAlgorithmFiberVolumeStatistics extends ProcessingAlgorithm{
	//output params
	private ParamObject<double[][]> avgstats;
	private ParamObject<double[][]> sumstats;
	private ParamObject<double[][]> maxstats;
	private ParamObject<double[][]> minstats;
	
	
	private ParamObject<double[][]> fiberlengths; 
	
	//input params
	private ParamObject<FiberCollection> fibers;
	private ParamVolume volume;
	private ParamOption comparison;
	private ParamPointDouble resolution;
	
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(fibers=new ParamObject<FiberCollection>("Fibers", new FiberCollectionReaderWriter()));
		inputParams.add(volume=new ParamVolume("Volume",null,-1,-1,-1,-1));
		volume.setMandatory(false);
		inputParams.add(comparison = new ParamOption("Comparison",new String[]{"Sum", "Mean", "Max"}));
		inputParams.add(resolution=new ParamPointDouble("Resolution",new Point3d(1,1,1)));
		inputParams.setCategory("IACL.DTI.Fiber");
		inputParams.setName("fiberVolumeStats");
		inputParams.setLabel("Fiber Stats from Volume");
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
//		dwiMotionCorr = new ParamVolumeCollection("Output Diffusion-weighted Volumes");
		outputParams.add(fiberlengths = new ParamObject<double[][]>("Fiber Lengths", new ArrayDoubleTxtReaderWriter()));
		
		outputParams.add(avgstats = new ParamObject<double[][]>("Mean Volume Data", new ArrayDoubleTxtReaderWriter()));
		avgstats.setMandatory(false);
		outputParams.add(sumstats = new ParamObject<double[][]>("Sum Volume Data", new ArrayDoubleTxtReaderWriter()));
		sumstats.setMandatory(false);
		outputParams.add(maxstats = new ParamObject<double[][]>("Max Volume Data", new ArrayDoubleTxtReaderWriter()));
		maxstats.setMandatory(false);
		outputParams.add(minstats = new ParamObject<double[][]>("Min Volume Data", new ArrayDoubleTxtReaderWriter()));
		minstats.setMandatory(false);
		
		
	}
	
	protected void execute(CalculationMonitor monitor) {

		
//		DecimalFormat dist = new DecimalFormat("###.#######");
		
		FiberStatistics fstat = new FiberStatistics(fibers.getObject());
		fstat.setRes(resolution.getParamX().getDouble(), resolution.getParamY().getDouble(), resolution.getParamZ().getDouble());
		fstat.computeLengths();
		ArrayList<Double> lens = fstat.getFiberLengths();
		double[][] arraylens = toArray(lens);
		lens=null;
		fiberlengths.setObject(arraylens);
		fiberlengths.setFileName(fibers.getName()+"_lengths");
		
		if(volume.getValue()!=null){
			fstat.findTractVolumeStats(volume.getImageData());

			ArrayList<Double> avg = fstat.getMeanFromVolume();
			ArrayList<Double> sum = fstat.getSumFromVolume();
			ArrayList<Double> max = fstat.getMaxFromVolume();
			ArrayList<Double> min = fstat.getMaxFromVolume();
			double[][] avgout = toArray(avg);
			avg=null;
			double[][] sumout = toArray(sum);
			sum=null;
			double[][] maxout = toArray(max);
			max=null;
			double[][] minout = toArray(min);
			min=null;


			avgstats.setObject(avgout);
			avgstats.setFileName(fibers.getName()+"_avgdata_"+volume.getImageData().getName());
			sumstats.setObject(sumout);
			sumstats.setFileName(fibers.getName()+"_sumdata_"+volume.getImageData().getName());
			maxstats.setObject(maxout);
			maxstats.setFileName(fibers.getName()+"_maxdata_"+volume.getImageData().getName());
			minstats.setObject(minout);
			minstats.setFileName(fibers.getName()+"_mindata_"+volume.getImageData().getName());
		}
		
		
	}
	
	private double[][] toArray(ArrayList<Double> in ){
		double[][] out = new double[in.size()][1];
		for(int i=0; i<in.size(); i++){
			out[i][0]=in.get(i);
		}
		return out;
	}
}
