package edu.jhu.ece.iacl.plugins.hardi;

import imaging.Scheme;
import imaging.SchemeV1;
import inverters.AlgebraicDT_Inversion;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearDT_Inversion;
import inverters.NonLinearDT_Inversion;
import inverters.RestoreDT_Inversion;
import inverters.TensorModelFitter;
import inverters.WeightedLinearDT_Inversion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.List;

import javax.vecmath.Point3f;


import com.thoughtworks.xstream.XStream;

import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.algorithms.dti.EstimateTensorLLMSE;
import edu.jhu.ece.iacl.algorithms.hardi.SurfaceTools;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.MipavController;
import edu.jhu.ece.iacl.io.StringArrayXMLReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.*;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamNumberCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.plugins.dti.DWIDefineCaminoScheme;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;


public class GradToSurf extends ProcessingAlgorithm{

	/****************************************************
	 * Input Parameters 
	 ****************************************************/	
	private ParamFile grad;
	private ParamBoolean mirrorDirections;

	/****************************************************
	 * Output Parameters
	 ****************************************************/

	private ParamSurface surface;

	private static final String rcsid =
		"$Id: GradToSurf.java,v 1.1 2008/12/18 19:06:05 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {

		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setName("Grad->Surface");
		inputParams.setLabel("Convert Grad->Surface");	
		inputParams.setCategory("Modeling.Diffusion");
		inputParams.setPackage("IACL");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/site/bennettlandman/"));
		//		info.setDescription("Prunes the nodes of a surface to select only unique diffusion directions.");
		//		info.setLongDescription("Prunes the nodes of a surface to select only unique diffusion directions.");
		info.setAffiliation("Johns Hopkins University");						
		info.setVersion(revnum);	


		/****************************************************
		 * Step 2. Add input parameters to control system 
		 ****************************************************/
		inputParams.add(grad = new ParamFile("Gradient Table",new FileExtensionFilter(new String[]{"grad"})));		
		inputParams.add(this.mirrorDirections=new ParamBoolean("Mirror diffusion directions",true));

	}

	protected void createOutputParameters(ParamCollection outputParams) {
		/****************************************************
		 * Step 1. Add output parameters to control system 
		 ****************************************************/
		outputParams.add(surface=new ParamSurface("Output Surface"));

	}

	protected void execute(CalculationMonitor monitor) {
		float [][]grads=null;
		TextFileReader text = new TextFileReader(grad.getValue());
		try {
			grads  = text.parseFloatFile();
		} catch (IOException e) { 

			throw new RuntimeException("LLMSE: Unable to parse grad-file");
		}
		Point3f []pts;
		if(this.mirrorDirections.getValue()) {
			pts = new Point3f[grads.length*2];
			for(int i=0;i<grads.length;i++) {
				pts[2*i]=new Point3f(grads[i][0],grads[i][1],grads[i][2]);
				pts[2*i+1]=new Point3f(-grads[i][0],-grads[i][1],-grads[i][2]);
			}
		} else {
			pts = new Point3f[grads.length];
			for(int i=0;i<grads.length;i++) {
				pts[i]=new Point3f(grads[i][0],grads[i][1],grads[i][2]);			
			}
		
		}
		EmbeddedSurface surf=null;
		if(pts.length>3)
			surf=new EmbeddedSurface(SurfaceTools.quickHull3D(pts));
		else 
			surf =new EmbeddedSurface((pts), new int[]{0,1,2});

		surf.setName(DWIDefineCaminoScheme.getFileNameWithoutExtension(grad.getValue().getName()));
		surface.setValue(surf);
	}

}