package edu.jhu.ece.iacl.plugins.utilities.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;

public class FileCollectionToPins extends ProcessingAlgorithm {

	ParamFileCollection a;
	ParamFileCollection b;
	ParamFileCollection out;
	ParamInteger startindex;
	
	private static final String rcsid =
		"$Id: FileCollectionToPins.java,v 1.1 2009/03/27 01:28:44 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "") .replace(" ", "");

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		FileExtensionFilter fef = new FileExtensionFilter();
		inputParams.add(a = new ParamFileCollection("File Collection", fef));
		inputParams.add(b = new ParamFileCollection("File Collection to add",fef));
		inputParams.add(startindex = new ParamInteger("Index to insert"));
		startindex.setValue(-1);
		
		inputParams.setName("addToFileCollection");
		inputParams.setLabel("Add to File Collection v" +revnum);
		inputParams.setCategory("IACL.Utilities.File");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		FileExtensionFilter fef = new FileExtensionFilter();
		outputParams.add(out = new ParamFileCollection("Output File Collection",fef));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		List<File> alist = a.getValue();
		List<File> blist = b.getValue();
		int N = alist.size()+blist.size();
		int ind = startindex.getInt();
		if(ind<0){
			ind = alist.size();
		}
		ArrayList<File> filesout = new ArrayList<File>(N);

		int j = 0;
		int k = 0;
		for(int i=0;i<N;i++){
			if(i<ind){
				filesout.add(alist.get(j));
				j++;
			}else if(i>=(ind+blist.size())){
				filesout.add(alist.get(j));
				j++;
			}else{
				filesout.add(blist.get(k));
				k++;
			}
		}
		
		out.setValue(filesout);
		
	}

}
