package edu.jhu.ece.iacl.plugins.utilities.file;

import java.util.ArrayList;

import edu.jhu.ece.iacl.io.ArrayDoubleListTxtReaderWriter;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;

public class MedicAlgorithmConcatArrayDoubleTextLists extends ProcessingAlgorithm {

	
	ParamObject<ArrayList<double[][]>> obja, objb, objout;
	ParamInteger insertidx;
	
	private static final String rcsid =
		"$Id: MedicAlgorithmConcatArrayDoubleTextLists.java,v 1.3 2008/12/16 18:32:21 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").trim();

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(obja = new ParamObject<ArrayList<double[][]>>("Input Array", new ArrayDoubleListTxtReaderWriter()));
		inputParams.add(objb = new ParamObject<ArrayList<double[][]>>("Array to Concatenate", new ArrayDoubleListTxtReaderWriter()));
		inputParams.add(insertidx = new ParamInteger("Insertion Indexs"));
		insertidx.setValue(-1);
		
		inputParams.setName("ConcatArrayDoubleTextLists");
		inputParams.setLabel("Concat Array Double Lists");
		inputParams.setCategory("IACL.Utilities.File");
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(objout = new ParamObject<ArrayList<double[][]>>("Resulting Array", new ArrayDoubleListTxtReaderWriter()));

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		int idx = insertidx.getInt();
		ArrayList<double[][]> a= obja.getObject();
		ArrayList<double[][]> b= objb.getObject();
		ArrayList<double[][]> out;
		if(idx<0){
			for(double[][] d: b){
				a.add(d);
			}
			out=a;
		}else{
			out = new ArrayList<double[][]>();
			int i=0;
			int ai=0;
			int bi=0;
			
			while(i<(a.size()+b.size())){
				System.out.println("i: " +i);
				if(i>=idx && i<(idx+b.size())){
					System.out.println("Add from b");
					out.add(b.get(bi));
					bi++;
				}else{
					System.out.println("Add from a");
					out.add(a.get(ai));
					ai++;
				}
				i++;
			}
		}
		
		objout.setObject(out);
		objout.setFileName(obja.getName()+"_cat");
		
	}

}
