package edu.jhu.ece.iacl.plugins.utilities.file;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;

import java.util.TreeSet;
import java.util.ArrayList;
import java.util.List;
import java.io.File;

public class MedicAlgorithmVolumeListOrganizer extends ProcessingAlgorithm{
	
	ParamVolumeCollection in, out;
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolumeCollection("Volumes In"));
		inputParams.setName("volListOrganize");
		inputParams.setLabel("Volume List Organizer");
		inputParams.setCategory("IACL.Utilities.File");
	}
	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(out=new ParamVolumeCollection("Volumes Out"));
	}
	protected void execute(CalculationMonitor monitor) {
		List<File> filelist = in.getFileList();
		TreeSet<String> fileset = new TreeSet<String>();
		for(File f: filelist){
			fileset.add(f.getAbsolutePath());
		}
		
		int i=0;
		for(String s : fileset){
			out.set(i, new File(s));
			i++;
		}
		
		System.out.println("Input List:");
		System.out.println(in.getFileList());
		System.out.println("Output List:");
		System.out.println(out.getFileList());
		System.out.println("Finished!");
		
		
	}

}
