package edu.jhu.ece.iacl.plugins.utilities.file;

import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.io.ZipFileReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.*;



/*
 * This module zips files (uzing GZip) not ending in .gz or .zip
 * and unzips files ending in .gz or .zip
 */
public class MedicAlgorithmZip extends ProcessingAlgorithm{
	
	private ParamFileCollection FilesIn;
	private ParamFile tempdir;
	
	private ParamFileCollection FilesOut;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmZip.java,v 1.3 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.add(FilesIn=new ParamFileCollection("File In"));
		inputParams.add(tempdir=new ParamFile("Destination Directory"));
		inputParams.setName("zipFile");
		inputParams.setLabel("Zip/Unzip Files");
		inputParams.setCategory("IACL.Utilities.File");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription("Unzips '.zip' and '.gz' files.  Zips files and file collections");
		info.setAffiliation("");
		info.add(new Citation(""));
		info.add(new Citation(""));		
		info.setVersion(revnum);	

	}
	protected void createOutputParameters(ParamCollection outputParams) {		
		FilesOut = new ParamFileCollection("File out");
		outputParams.add(FilesOut);
		
	}
	protected void execute(CalculationMonitor monitor) {
		
		String fileinname =FilesIn.getValue(0).getName();
		String fileinpath = FilesIn.getValue(0).getAbsolutePath();
		
		String dir = tempdir.getValue().getParentFile()+"/";
		
		System.out.println(fileinname);
		System.out.println(dir);
		
		ArrayList<File> filesout = new ArrayList<File>();
		
		//Zip if there are multiple input files
		if(FilesIn.size()>1){
			
		}else{
			//unzip if filename ends in "zip" or "gz".  Otherwise zip
		System.out.println(fileinname);
		System.out.println(fileinname.substring(fileinname.length()-3, fileinname.length()));
		System.out.println(fileinname.substring(fileinname.length()-2, fileinname.length()));
			if(fileinname.substring(fileinname.length()-3, fileinname.length()).equals("zip")){
				System.out.println("unzipping .zip");
				try {
			        // Open the ZIP file
			        ZipInputStream in = new ZipInputStream(new FileInputStream(fileinpath));
			    
			        while(in.available()>0){
			        	// Get the first entry
			        	ZipEntry entry = in.getNextEntry();

			        	// Open the output file
			        	String outFilename = dir+entry.getName();	
			        	filesout.add(new File(outFilename));
			        	FileOutputStream out = new FileOutputStream(outFilename);
			        	
			        	// Transfer bytes from the ZIP file to the output file
			        	byte[] buf = new byte[1024];
			        	int len;
			        	while ((len = in.read(buf)) > 0) {
			        		out.write(buf, 0, len);
			        	}
			        	 //Close this output stream
				        out.close();
			        }
			        
			        //Close the input stream
			        in.close();
			    } catch (IOException e) {
			    	e.printStackTrace();
			    }
			}else if(fileinname.substring(fileinname.length()-2, fileinname.length()).equals("gz")){
				System.out.println("unzipping .gz");
				try {
			        // Open the compressed file
			        GZIPInputStream in = new GZIPInputStream(new FileInputStream(fileinpath));
			    
			        // Open the output file
			        String outFilename = dir+fileinname.substring(0, fileinname.length()-3);
			        filesout.add(new File(outFilename));
			        FileOutputStream out = new FileOutputStream(outFilename);
			    
			        // Transfer bytes from the compressed file to the output file
			        byte[] buf = new byte[1024];
			        int len;
			        while ((len = in.read(buf)) > 0) {
			            out.write(buf, 0, len);
			        }
			    
			        // Close the file and stream
			        in.close();
			        out.close();
			    } catch (IOException e) {
			    	e.printStackTrace();
			    }
			}//Otherwise, zip the file
			else{
				System.out.println("zipping to .gz");
				try {
			        // Create the GZIP output stream
			        String outFilename = dir+fileinname+".gz";
			        filesout.add(new File(outFilename));
			        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFilename));
			    
			        // Open the input file
			        System.out.println(fileinname);
			        FileInputStream in = new FileInputStream(fileinpath);
			    
			        // Transfer bytes from the input file to the GZIP output stream
			        byte[] buf = new byte[1024];
			        int len;
			        while ((len = in.read(buf)) > 0) {
			            out.write(buf, 0, len);
			        }
			        in.close();
			    
			        // Complete the GZIP file
			        out.finish();
			        out.close();
			    } catch (IOException e) {
			    	e.printStackTrace();
			    }
			}
		}
		
		FilesOut.setValue(filesout);
		
	}
	
}