/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurfaceCollection;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmSerializeSurfaces extends ProcessingAlgorithm{

	ParamSurfaceCollection collection;
	ParamSurface surface;
	ParamInteger index;
	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(false);
		inputParams.add(collection=new ParamSurfaceCollection("Surfaces"));
		inputParams.add(index=new ParamInteger("Index",0));
		inputParams.setName("serialize_surfs");
		inputParams.setLabel("Serialize Surfaces");
		inputParams.setCategory("IACL.Utilities.Logic");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(surface=new ParamSurface("Surface"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		surface.setValue(collection.getSurfaceList().get(index.getInt()));
	}
	
}
