/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmSerializeVolumes extends ProcessingAlgorithm{

	ParamVolumeCollection collection;
	ParamVolume volume;
	ParamInteger index;
	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(false);
		inputParams.add(collection=new ParamVolumeCollection("Volumes"));
		inputParams.add(index=new ParamInteger("Index",0));
		inputParams.setName("serialize_vols");
		inputParams.setLabel("Serialize Volumes");
		inputParams.setCategory("IACL.Utilities.Logic");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(volume=new ParamVolume("Volume"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		volume.setValue(collection.getImageDataList().get(index.getInt()));
	}
	
}
