/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmSurfaceSplitter extends ProcessingAlgorithm{
	private ParamSurface inSurf;
	private ParamSurface outSurf;
	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(false);
		inputParams.add(inSurf=new ParamSurface("Surface"));
		inputParams.setName("surf_splitter");
		inputParams.setLabel("Surface Splitter");
		inputParams.setCategory("IACL.Utilities.Logic");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSurf=new ParamSurface("Surface"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		outSurf.setValue(inSurf.getValue());
	}
}
