package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;

public class MedicAlgorithmValueInRange extends ProcessingAlgorithm{
	protected ParamDouble lowerBound;
	protected ParamDouble upperBound;
	protected ParamDouble value;
	protected ParamBoolean inclusive;
	protected ParamBoolean assertTrue;
		protected void createInputParameters(ParamCollection inputParams) {
			setRunningInSeparateProcess(false);
			inputParams.add(value=new ParamDouble("Value"));
			inputParams.add(lowerBound=new ParamDouble("Lower Bound"));
			inputParams.add(upperBound=new ParamDouble("Upper Bound"));
			inputParams.add(inclusive=new ParamBoolean("Include Bounds",true));
			inputParams.setName("val_in_range");
			inputParams.setLabel("Value In Range");
			inputParams.setCategory("IACL.Utilities.Logic");
		}
		protected void createOutputParameters(ParamCollection outputParams) {
			outputParams.add(assertTrue=new ParamBoolean("Assertion"));
		}
		protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
			double val=value.getDouble();
			double lower=lowerBound.getDouble();
			double upper=upperBound.getDouble();
			if(inclusive.getValue()){
				assertTrue.setValue((val>=lower&&val<=upper));
			} else {
				assertTrue.setValue((val>lower&&val<upper));
			}
		}
}
