package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;

public class MedicAlgorithmValueLessThan extends ProcessingAlgorithm{

	protected ParamDouble upperBound;
	protected ParamDouble value;
	protected ParamBoolean inclusive;
	protected ParamBoolean assertTrue;
		protected void createInputParameters(ParamCollection inputParams) {
			setRunningInSeparateProcess(false);
			inputParams.add(value=new ParamDouble("Value"));
			inputParams.add(upperBound=new ParamDouble("Upper Bound"));
			inputParams.add(inclusive=new ParamBoolean("Include Bound",true));
			inputParams.setName("val_less_than");
			inputParams.setLabel("Value Less Than");
			inputParams.setCategory("IACL.Utilities.Logic");
		}
		protected void createOutputParameters(ParamCollection outputParams) {
			outputParams.add(assertTrue=new ParamBoolean("Assertion"));
		}
		protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
			double val=value.getDouble();
			double upper=upperBound.getDouble();
			if(inclusive.getValue()){
				assertTrue.setValue((val<=upper));
			} else {
				assertTrue.setValue((val<upper));
			}
		}
}
