/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmVolumeSplitter extends ProcessingAlgorithm{
	private ParamVolume inVol;
	private ParamVolume outVol;
	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(false);
		inputParams.add(inVol=new ParamVolume("Volume"));
		inputParams.setName("vol_splitter");
		inputParams.setLabel("Volume Splitter");
		inputParams.setCategory("IACL.Utilities.Logic");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Volume"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		outVol.setValue(inVol.getValue());
	}
}
