package edu.jhu.ece.iacl.plugins.utilities.math;

import edu.jhu.bme.smile.commons.math.KLDivergence;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.plugins.MapsUtil;
import edu.jhu.ece.iacl.structures.image.ImageDataColor;
import edu.jhu.ece.iacl.structures.image.VoxelType;

public class MedicAlgorithmKLDivergence extends ProcessingAlgorithm{

	protected ParamDouble kld;
	protected ParamDouble kernelSize;
	protected ParamBoolean yLogScale;
	protected ParamInteger rows,cols;
	protected ParamObject<double[][]> histX,histY;
	protected ParamVolume histImg;
	protected ParamString valueName;
	protected void createInputParameters(ParamCollection inputParams) {
		algorithmInformation.setDescription("Computes KL divergence between two histograms using kernel density estimation.");
		algorithmInformation.setVersion(MapsUtil.parseCVSRevision("$Revision: 1.1 $"));
		inputParams.add(histX=new ParamObject<double[][]>("Histogram X",new ArrayDoubleTxtReaderWriter()));
		inputParams.add(histY=new ParamObject<double[][]>("Histogram Y",new ArrayDoubleTxtReaderWriter()));
		inputParams.add(rows=new ParamInteger("Image Width",0,1600,800));
		inputParams.add(cols=new ParamInteger("Image Height",0,1600,600));
		inputParams.add(kernelSize=new ParamDouble("Kernel Size ",0,1E30,1));
		inputParams.add(valueName=new ParamString("Measurement Name","value"));
		inputParams.add(yLogScale=new ParamBoolean("Probability in Log Scale",true));
		inputParams.setName("kl_divergence");
		inputParams.setLabel("KL Divergence");
		inputParams.setCategory("IACL.Measurement.Statistics");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(histImg=new ParamVolume("Histogram Image",VoxelType.COLOR_FLOAT));
		outputParams.add(kld=new ParamDouble("KL Divergence"));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		KLDivergence kldiv=new KLDivergence();
		kld.setValue(kldiv.KLdivergence(histX.getObject(), histY.getObject(), kernelSize.getDouble()));
		String nameX=histX.getValue().getName();
		String nameY=histY.getValue().getName();
		ImageDataColor img=kldiv.getImage(nameX,nameY,valueName.getValue(),yLogScale.getValue(),rows.getInt(),cols.getInt());
		img.setName(nameX+"_kld");
		histImg.setValue(img);
	}

}
