package edu.jhu.ece.iacl.plugins.utilities.surface;

import edu.jhu.ece.iacl.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.FileReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;

public class MedicAlgorithmEmbedSurface extends ProcessingAlgorithm{
	ParamSurface surf;
	ParamSurface outSurf;
	ParamOption replaceorappend;
	ParamObject<double[][]> data;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(surf=new ParamSurface("Surface"));
		inputParams.add(data=new ParamObject<double[][]>("Data"));
		inputParams.add(replaceorappend=new ParamOption("Method",new String[]{"Append","Replace"}));
		data.setReaderWriter(new ArrayDoubleReaderWriter());
		inputParams.setLabel("Embed Data in Surface");
		inputParams.setName("embedsurf");
		inputParams.setCategory("IACL.Utilities.Surface");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSurf=new ParamSurface("Embedded Surface"));
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		if(replaceorappend.getIndex()==0){
			EmbeddedSurface surfDup=new EmbeddedSurface(surf.getSurface(),(double[][])data.getObject());
			outSurf.setValue(surfDup);
		} else {
			EmbeddedSurface surfDup=surf.getSurface();
			surfDup.setVertexData((double[][])data.getObject());
			outSurf.setValue(surfDup);
		}
	}

}
