package edu.jhu.ece.iacl.plugins.utilities.surface;

import java.io.File;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;

import gov.nih.mipav.model.structures.TransMatrix;

public class MedicAlgorithmReshapeSurface extends ProcessingAlgorithm{
	ParamPointDouble offset;
	ParamDouble scaleMesh,scaleData;
	ParamSurface inSurf,outSurf;
	ParamMatrix transMatrix;
	ParamBoolean invert;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inSurf=new ParamSurface("Surface"));
		inputParams.add(scaleMesh=new ParamDouble("Scale Vertices",0,1000,1));
		inputParams.add(scaleData=new ParamDouble("Scale Embedded Data",0,1000,1));
		inputParams.add(offset=new ParamPointDouble("Offset"));
		inputParams.add(transMatrix=new ParamMatrix("Transformation Matrix",4,4));
		for (int i = 0; i < 4; i++)
			transMatrix.setValue(i, i, 1);
		inputParams.add(invert=new ParamBoolean("Invert Matrix",false));
		inputParams.setName("reshapesurf");
		inputParams.setLabel("Reshape Surface");
		inputParams.setCategory("IACL.Utilities.Surface");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSurf=new ParamSurface("Surface"));
		outputParams.setName("reshapesurf");
		outputParams.setLabel("Reshape Surface");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		EmbeddedSurface surf=inSurf.getSurface();
		surf.scaleVertices(scaleMesh.getFloat());
		surf.scaleData(scaleData.getFloat());
		surf.translate(new Point3f(offset.getValue()));
		Jama.Matrix m=transMatrix.getValue();
		if(invert.getValue())m=m.inverse();
		surf.transform(transMatrix.getValue());
		outSurf.setValue(surf);
	}

}
