package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;

public class GetImageDimensions extends ProcessingAlgorithm {
	
	private ParamVolume Vol;
	private ParamInteger dimX, dimY, dimZ, dimT, resX, resY, resZ;

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(Vol=new ParamVolume("Volume"));
		inputParams.setName("ImageDims");
		inputParams.setLabel("Get Image Dimensions");
		inputParams.setCategory("IACL.Utilities.Volume");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(dimX = new ParamInteger("X dimension"));	
		outputParams.add(dimY = new ParamInteger("Y dimension"));	
		outputParams.add(dimZ = new ParamInteger("Z dimension"));
		outputParams.add(dimT = new ParamInteger("T dimension"));
		
		outputParams.add(resX = new ParamInteger("X resolution"));	
		outputParams.add(resY = new ParamInteger("Y resolution"));	
		outputParams.add(resZ = new ParamInteger("Z resolution"));
	}
	
	protected void execute(CalculationMonitor monitor) {
		
		dimX.setValue(Vol.getModelImage().getExtents()[0]);
		dimY.setValue(Vol.getModelImage().getExtents()[1]);
		dimZ.setValue(Vol.getModelImage().getExtents()[2]);
		dimT.setValue(Vol.getModelImage().getExtents()[3]);
		
		resX.setValue(Vol.getModelImage().getResolutions(0)[0]);
		resY.setValue(Vol.getModelImage().getResolutions(0)[1]);
		resZ.setValue(Vol.getModelImage().getResolutions(0)[2]);
		
		System.out.println(dimX);
		System.out.println(dimY);
		System.out.println(dimZ);
		System.out.println(dimT);
		
		System.out.println(resX);
		System.out.println(resY);
		System.out.println(resZ);
	}
	
}
