package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;

public class MedicAlgorithmAddToVolCollection extends ProcessingAlgorithm{
	
	//input params
	private ParamVolumeCollection volcol;
	private ParamVolumeCollection addme;
	
	// output params
	private ParamVolumeCollection volcolout;
	
	protected void createInputParameters(ParamCollection inputParams) {
		
		addme = new ParamVolumeCollection("Volume(s) to Add");
		inputParams.add(addme);
		
		volcol = new ParamVolumeCollection("Volume Collection");
		inputParams.add(volcol);
		volcol.setMandatory(false);
		
		inputParams.setName("addToVolCollection");
		inputParams.setLabel("Add To Volume Collection");
		inputParams.setCategory("IACL.Utilities.Volume");
	}

	protected void createOutputParameters(ParamCollection outputParams) {		
		volcolout = new ParamVolumeCollection("Volume Collection Out");
		outputParams.add(volcolout);
	}
	
	protected void execute(CalculationMonitor monitor) {
		List<ImageData> list;
		if(volcol.getValue().size()>0){
			list = volcol.getImageDataList();
			for(ImageData idat: addme.getImageDataList()){
				list.add(idat);
			}
		}else{
			list = new ArrayList<ImageData>();
			for(ImageData idat: addme.getImageDataList()){
				list.add(idat);
			}
			
		}
		
		volcolout.setValue(list);
		
	
	}
	
}
