package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.io.FileReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

import gov.nih.mipav.model.file.FileInfoBase;

public class MedicAlgorithmCombineSubimages extends ProcessingAlgorithm{
	
	ParamVolumeCollection subVolumes;
	ParamVolume superVolume;
	ParamInteger catdim;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmCombineSubimages.java,v 1.3 2008/12/19 21:10:25 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(subVolumes = new ParamVolumeCollection("Sub-Volumes",null,-1,-1,-1,-1));
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription("Recombines the output (or processed output) of 'Split Images'." +
				"Also can concatenate volumes across an arbitrary dimension (if possible).");
		info.add(new Citation(""));
		info.add(new Citation(""));		
		info.setVersion(revnum);	
		
		inputParams.add(catdim=new ParamInteger("Dimension to Combine"));
		catdim.setValue(-1);
		catdim.setMandatory(false);
		
		inputParams.setName("combineSubImages");
		inputParams.setLabel("Combine Sub-Images");
		inputParams.setCategory("IACL.Utilities.Volume");
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(superVolume=new ParamVolume("Volume Out",null,-1,-1,-1,-1));
		superVolume.getExtensionFilter().setPreferredExtension("nii");
	}

	protected void execute(CalculationMonitor monitor) {
		superVolume.setValue(combine());
	}
	
	public ImageDataMipav combine(){
		
		int numRows;
		int numCols;
		int numSlices;
		int numComponents;
		
		int dim = -1;
		
		System.out.println(catdim.getValue().intValue());
		if(catdim.getValue().intValue()>0){
			
			dim = catdim.getValue().intValue();
			System.out.println("DIMENSION: " + dim);
			
			numRows = subVolumes.getImageDataList().get(0).getRows();
			numCols = subVolumes.getImageDataList().get(0).getCols();
			numSlices = subVolumes.getImageDataList().get(0).getSlices();
			numComponents = subVolumes.getImageDataList().get(0).getComponents();
			
			if(dim==0){
				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numRows = numRows+subVolumes.getImageDataList().get(i).getRows();
				}
			}else if(dim==1){
				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numCols = numCols+subVolumes.getImageDataList().get(i).getCols();
				}
			}else if(dim==2){
				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numSlices = numSlices+subVolumes.getImageDataList().get(i).getSlices();
				}
			}else if(dim==3){
				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numComponents = numComponents+subVolumes.getImageDataList().get(i).getComponents();
				}
			}
		
		}else{
			if(subVolumes.getValue(0).getName().contains("Rows") || catdim.getValue().intValue()==0 ){
				System.out.println("Concatenating by Rows");
				numRows = subVolumes.getImageDataList().get(0).getRows();
				numCols = subVolumes.getImageDataList().get(0).getCols();
				numSlices = subVolumes.getImageDataList().get(0).getSlices();
				numComponents = subVolumes.getImageDataList().get(0).getComponents();

				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numRows = numRows+subVolumes.getImageDataList().get(i).getRows();
				}
				dim=0;
			}else if(subVolumes.getValue().get(0).getName().contains("Cols") ||catdim.getValue().intValue()==1 ){
				System.out.println("Concatenating by Cols");
				numRows = subVolumes.getImageDataList().get(0).getRows();
				numCols = subVolumes.getImageDataList().get(0).getCols();
				numSlices = subVolumes.getImageDataList().get(0).getSlices();
				numComponents = subVolumes.getImageDataList().get(0).getComponents();

				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numCols = numRows+subVolumes.getImageDataList().get(i).getCols();
				}
				dim=1;
			}else if(subVolumes.getValue().get(0).getName().contains("Slices") || catdim.getValue().intValue()==2){
				System.out.println("Concatenating by Slices");
				numRows = subVolumes.getImageDataList().get(0).getRows();
				numCols = subVolumes.getImageDataList().get(0).getCols();
				numSlices = subVolumes.getImageDataList().get(0).getSlices();
				numComponents = subVolumes.getImageDataList().get(0).getComponents();

				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numSlices = numRows+subVolumes.getImageDataList().get(i).getSlices();
				}
				dim=2;
			}else if(subVolumes.getValue().get(0).getName().contains("Comps") || catdim.getValue().intValue()==3){
				System.out.println("Concatenating by Component");
				numRows = subVolumes.getImageDataList().get(0).getRows();
				numCols = subVolumes.getImageDataList().get(0).getCols();
				numSlices = subVolumes.getImageDataList().get(0).getSlices();
				numComponents = subVolumes.getImageDataList().get(0).getComponents();

				for(int i=1; i<subVolumes.getImageDataList().size(); i++){
					numComponents = numRows+subVolumes.getImageDataList().get(i).getComponents();
				}
				dim=3;
			}else{
				numRows = 0;
				numCols = 0;
				numSlices = 0;
				numComponents = 0;
			}
		}
		
		ImageDataMipav volume = new ImageDataMipav(subVolumes.getFileList().get(0).getName()+ "_Combined",subVolumes.getImageDataList().get(0).getType(),
				numRows, numCols, numSlices, numComponents);

		//set the fileinfo for the new volume:
		FileInfoBase[] finfo = subVolumes.getImageDataList().get(0).getModelImage().getFileInfo();
		FileInfoBase[] fcat = new FileInfoBase[numSlices*numComponents];
		for(int i=0; i<fcat.length; i++){
			fcat[i]=finfo[0];
		}
		volume.getModelImage().setFileInfo(fcat);
		
		//set the Data for the new volume:
		List<ImageData> sortedVols = sortFileNames(subVolumes);	//need Volumes to be in order
		
		if(dim==0){
			int count=0;
			for(ImageData v : sortedVols){
				System.out.println(v.getName());
				for(int i=0; i<v.getRows(); i++){
					for(int j=0; j<v.getCols(); j++){
						for(int k=0; k<v.getSlices(); k++){
							for(int l=0; l<v.getComponents(); l++){
								volume.set(count,j,k,l,v.getDouble(i, j, k,l));
							}
						}
					}
					count++;
				}	

			}
		}else if(dim==1){
			int count=0;
			for(ImageData v : sortedVols){
				System.out.println(v.getName());
				for(int j=0; j<v.getCols(); j++){
					for(int i=0; i<v.getRows(); i++){
						for(int k=0; k<v.getSlices(); k++){
							for(int l=0; l<v.getComponents(); l++){
								volume.set(i,count,k,l,v.getDouble(i, j, k,l));
							}
						}
					}
					count++;
				}	

			}
		}else if(dim==2){
			int count=0;
			for(ImageData v : sortedVols){
				System.out.println(v.getName());
				for(int k=0; k<v.getSlices(); k++){
					for(int j=0; j<v.getCols(); j++){
						for(int i=0; i<v.getRows(); i++){
							for(int l=0; l<v.getComponents(); l++){
								volume.set(i,j,count,l,v.getDouble(i, j, k,l));
							}
						}
					}
					count++;
				}	

			}
		}else if(dim==3){
			int count=0;
			for(ImageData v : sortedVols){
				System.out.println(v.getName());
				for(int l=0; l<v.getComponents(); l++){
					for(int j=0; j<v.getCols(); j++){
						for(int k=0; k<v.getSlices(); k++){
							for(int i=0; i<v.getRows(); i++){
								volume.set(i,j,k,count,v.getDouble(i, j, k,l));
							}
						}
					}
					count++;
				}	

			}
		}else{
			System.err.println("Invalid dim. => Invalid input volumes");
		}
		
		return volume;
	}
	
	private List<ImageData> sortFileNames(ParamVolumeCollection collectionIn){
		int num = collectionIn.size();
		int counter, index;
		ImageData temp;
		List<ImageData> out = collectionIn.getImageDataList();
		for (counter=0; counter<num-1;counter++){
			for(index =0; index<num-1-counter;index++){
				
				if(out.get(index).getName().compareTo (out.get(index+1).getName())<0){
					temp=out.get(index);
					out.set(index,out.get(index+1));
					out.set(index+1, temp);
				}
			}
		}
		
		return out;
	}
	
}
