/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.List;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmCombineVolumeComponents extends ProcessingAlgorithm{
	
	ParamVolumeCollection inVols;
	ParamVolume outVol;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inVols=new ParamVolumeCollection("Volumes"));
		inputParams.setLabel("Combine Volume Components");
		inputParams.setName("comb_vol_comp");
		inputParams.setCategory("IACL.Utilities.Volume");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Multi-Component Volume",null,-1,-1,-1,-1));

	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#execute(edu.jhu.ece.iacl.pipeline.CalculationMonitor)
	 */
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		List<ImageData> vols=inVols.getImageDataList();
		int comp=vols.size();
		ImageData first=vols.get(0);
		ImageDataMipav cvol=new ImageDataMipav(vols.get(0).getName()+"_vec",first.getType(),first.getRows(),first.getCols(),first.getSlices(),comp);
		for(int i=0;i<cvol.getRows();i++){
			for(int j=0;j<cvol.getCols();j++){
				for(int k=0;k<cvol.getSlices();k++){
					for(int l=0;l<comp;l++){
						cvol.set(i,j,k,l,vols.get(l).getDouble(i, j, k));
					}
				}
			}
		}
		outVol.setValue(cvol);
	}
	
}
