/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.Arrays;
import java.util.List;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 */
public class MedicAlgorithmCombineVolumes extends ProcessingAlgorithm {
	ParamVolumeCollection vols;
	ParamVolume volParam;
	ParamOption method;
	ParamDouble scale;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(vols = new ParamVolumeCollection("Volumes"));
		inputParams.add(method = new ParamOption("Method", new String[] { "Average", "Logit" ,"Median"}));
		inputParams.add(scale=new ParamDouble("Scale down by",255.0));
		inputParams.setLabel("Combine Volumes");
		inputParams.setName("comb_vols");
		inputParams.setCategory("IACL.Utilities.Volume");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#createOutputParameters(edu.jhu.ece.iacl.pipeline.parameter.ParamCollection)
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		outputParams.add(volParam = new ParamVolume("Combined Volume"));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#execute(edu.jhu.ece.iacl.pipeline.CalculationMonitor)
	 */
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		List<ImageData> tmp = vols.getImageDataList();
		ImageData first = tmp.get(0);
		ImageDataFloat vol = new ImageDataFloat(first.getName() + "_avg", first.getRows(), first.getCols(), first
				.getSlices());
		float sum;
		float p;
		float sc=scale.getFloat();
		float min=1E10f;
		float max=-1E10f;
		int count=0;
		float val;
		float[] cache=new float[tmp.size()];
		for (int i = 0; i < first.getRows(); i++) {
			for (int j = 0; j < first.getCols(); j++) {
				for (int k = 0; k < first.getSlices(); k++) {
					sum = 0;
					switch (method.getIndex()) {
					case 0:
						count=0;
						for (int l = 0; l < tmp.size(); l++) {
							ImageData v = tmp.get(l);
							val= v.getFloat(i, j, k);
							if(val!=0){
								sum +=val;
								count++;
							}
						}
						sum = (count>0)?sum/count:0;
						break;
					case 1:
						for (int l = 0; l < tmp.size(); l++) {
							ImageData v = tmp.get(l);
							p=v.getFloat(i, j, k)/sc;
							sum+=((p<=0.000912)?-7:Math.log(p))-((p>=0.999088)?-7:Math.log(1-p));
							if(p>0.000912&&p<0.999088){
								min=Math.min(min,sum);
								max=Math.max(max,sum);
							}
						}
						double ex=Math.exp(sum/tmp.size());
						sum=(float)(sc*ex/(1.0+ex));
						break;
					case 2:
						
						for (int l = 0; l < tmp.size(); l++) {
							
							ImageData v = tmp.get(l);
							cache[l]=v.getFloat(i, j, k);
						}
						Arrays.sort(cache);
						if(tmp.size()%2==0){
							sum=0.5f*(cache[tmp.size()/2]+cache[tmp.size()/2-1]);
						} else {
							sum=cache[(tmp.size()-1)/2];
						}
						break;
					default:
					}
					vol.set(i, j, k, sum);
				}
			}
		}
		System.out.println("MIN LOGIT "+min+" MAX LOGIT "+max);
		volParam.setValue(vol);
	}
}
