package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;
import edu.jhu.ece.iacl.structures.image.*;
import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import gov.nih.mipav.model.structures.ModelImage;
import java.util.*;

import javax.vecmath.Point3i;

/**
 * Image Cropper
 * @author Navid Shiee
 *
 */
public class MedicAlgorithmCrop extends ProcessingAlgorithm{
	
	private ParamVolume inputVol;
			
	private ParamVolume outputVol;
	
	private ParamInteger borderSize;
	
	private ParamDouble threshold;
	private ParamPointInteger offset;
	private ParamPointInteger dim;
	/**
	 * Create input parameters for Cropper :cubic volume and borderSize
	 */
	public MedicAlgorithmCrop(){
		setName("Multi-Crop");
	}
	protected void createInputParameters(ParamCollection inputParams) {
		inputVol = new ParamVolume("Volume", null,-1,-1,-1,-1);
		borderSize = new ParamInteger("BorderSize", 0, Integer.MAX_VALUE);
		borderSize.setValue(3);
		threshold = new ParamDouble("Threshold", 0, Integer.MAX_VALUE);
		threshold.setValue(0);
		inputParams.add(inputVol);
		inputParams.add(threshold);
		inputParams.add(borderSize);
		inputParams.setLabel("Crop");
		inputParams.setName("crop");
		inputParams.setCategory("IACL.Utilities.Volume");
	}

	/**
	 * Create output parameters for Image Cropper: cubic volume and extents
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
/*		for (int i=0; i<6; i++){
			borders[i]= new ParamInteger("border",0,Integer.MAX_VALUE);
			outputParams.add(borders[i]);
		}*/
		offset=new ParamPointInteger("Offset");
		dim=new ParamPointInteger("Dimensions");
		outputParams.add(offset);
		outputParams.add(dim);
		outputVol = new ParamVolume(null,-1,-1,-1,-1);
		outputVol.setName("cropped");
		outputVol.setLabel("Cropped Image");
		outputParams.add(outputVol);
	}

	/**
	 * Execute Image Cropper
	 */
	protected void execute(CalculationMonitor monitor) {

		CubicVolumeCropper cropper = new CubicVolumeCropper();
		monitor.observe(cropper);
		ImageDataMipav vol=inputVol.getImageData();
		ImageData cvol=cropper.crop(vol,threshold.getInt(), borderSize.getInt());
		CropParameters params=cropper.getLastCropParams();
		offset.setValue(new Point3i(params.xmin,params.ymin,params.zmin));	
		dim.setValue(new Point3i(params.getCroppedRows(),params.getCroppedCols(),params.getCroppedSlices()));
		ImageDataMipav mvol=new ImageDataMipav(cvol);
		mvol.getModelImage().copyFileTypeInfo(vol.getModelImage());
		outputVol.setValue(cvol);
	}


}
