package edu.jhu.ece.iacl.plugins.utilities.volume;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;

public class MedicAlgorithmDimensions  extends ProcessingAlgorithm{
	ParamVolume vol;
	ParamPointInteger dims;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(vol=new ParamVolume("Volume"));
		inputParams.setName("dims");	
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setLabel("Volume Dimensions");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(dims=new ParamPointInteger("Dimensions"));
	}
	protected void execute(CalculationMonitor monitor) {
		ImageData VOL=vol.getImageData();
		dims.setValue(new Point3i(VOL.getRows(),VOL.getCols(),VOL.getSlices()));
	}

}
