package edu.jhu.ece.iacl.plugins.utilities.volume;


import edu.jhu.ece.iacl.algorithms.dti.DtiVecMask;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;

import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamNumber;




public class MedicAlgorithmMaskVectorImage  extends ProcessingAlgorithm{
	//private ParamSurface cruiseSurf;
	private ParamVolume mask;
	private ParamVolume vecimg;
	private ParamVolume outputVol;
	private ParamNumber target;

	protected void createInputParameters(ParamCollection inputParams) {
		/*
		inputParams.add(mask=new ParamVolume("Label Mask"));
		inputParams.setName("mask");
		inputParams.add(vecimg=new ParamVolume("Vector Image"));
		inputParams.setName("vecimg");
//		inputParams.add(target=new ParamNumber("Mask Target Value"));
//		inputParams.setName("target");
		
		inputParams.add(mask);
		inputParams.add(vecimg);
		inputParams.add(target);
		*/
		target = new ParamInteger("Mask Target Value", 0, 256);
		target.setValue(50);
		
		inputParams.add(mask=new ParamVolume("Label Mask"));
		inputParams.add(vecimg=new ParamVolume("Vector Field",null,3,-1,-1,-1));
		inputParams.add(target=new ParamInteger("Mask Target Value"));
		inputParams.setName("mask_vol");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setLabel("Mask Vector Volume");
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
		outputVol = new ParamVolume(null,-1,-1,-1,3);
		outputVol.setName("Vector Field");
		outputParams.add(outputVol);
		outputParams.setLabel("Masked Vector Field");
		outputParams.setName("vecout");
	}
	protected void execute(CalculationMonitor monitor) {
		DtiVecMask masker = new DtiVecMask();
		monitor.observe(masker);
		outputVol.setValue(masker.getSubsetDTISformat(vecimg.getImageData(), mask.getImageData(), target.getValue()));
		System.out.println("FINISHED");
	}


}