package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmSlabsToVolume extends ProcessingAlgorithm {

	//output params
	private ParamFileCollection outputFiles;	// Files to be split

	//input params
	private ParamFileCollection inputFiles;		// Files to be split
	private ParamInteger numslabs;
	
	//Variables
	ArrayList<File> recombVols;
	File outDir;
	CubicVolumeReaderWriter rw = CubicVolumeReaderWriter.getInstance();
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmSlabsToVolume.java,v 1.1 2008/12/23 20:00:52 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setLabel("Slabs to Volumes");
		inputParams.setName("SlabsToVolumes");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setPackage("Base");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));		
		info.setDescription("Concatenates a list of slabs (subsets) of volumes, to their corresponding volumes");
		info.setAffiliation("Johns Hopkins University");		
		info.setVersion(revnum);	
		
		// Input Parameters
		inputParams.add(inputFiles= new ParamFileCollection("Input Slab Files",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));				
		inputParams.add(numslabs= new ParamInteger("Number of Slabs"));

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outputFiles = new ParamFileCollection("Output Volumes",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
	}

	@Override
	protected void execute(CalculationMonitor monitor)throws AlgorithmRuntimeException {
		
		recombVols = new ArrayList<File>();
		List<File> slablist = inputFiles.getValue();
		int N = slablist.size();
		int nslabs = numslabs.getInt();
		int listidx =0;
		
		while(listidx<N){
			ArrayList<ImageData> catus = new ArrayList<ImageData>(nslabs);
			if((listidx+nslabs)<=N){
				for(int i=0; i<nslabs; i++){
					catus.add(rw.read(slablist.get(listidx)));
					listidx++;
				}
				catList(catus);
			}else{
				System.err.println("Ran out of slabs!");
				listidx = N;
			}
			
		}
		
		outputFiles.setValue(recombVols);
	}
	
	private void catList(List<ImageData> list){
		
		outDir = this.getOutputDirectory();
		//Find the total number of slices;
		int Slcs = 0;
		String tempname = list.get(0).getName();
		int s = tempname.indexOf("SlicesFrom_");
		String name = tempname.substring(0, s-1)+tempname.substring(s+12)+"_recombined";
		
		for(ImageData img : list){
			Slcs+=img.getSlices();
			if(!img.getName().contains(tempname.substring(0, s))){
				System.err.println("Warning! Names in list do not appear to be compatible!");
//				return null;
			}
		}
		
		
		ImageDataMipav out = new ImageDataMipav(name,list.get(0).getType(),list.get(0).getRows(), list.get(0).getCols(), Slcs);
		
		int slcidx = 0;
		for(ImageData img: list){
			for(int k=0; k<img.getSlices(); k++){
				for(int j=0; j<img.getCols(); j++){
					for(int i=0; i<img.getRows(); i++){
						out.set(i,j,slcidx,img.getDouble(i, j, k));
					}
				}
				slcidx++;
			}
		}
		
		//update Header Info
		ModelImage img=(out).getModelImage();
		FileUtil.updateFileInfo(list.get(0).getModelImage(),img);
		img.calcMinMax();
		
		
		File f = new File(outDir, FileUtil.forceSafeFilename(name) + "."+rw.getExtensionFilter().getPreferredExtension());
		System.out.println("Writing to disk..." + f);
		File f2 = rw.write(out, f);
		System.out.println(f2);
		if(f2!=null){
			recombVols.add(f2);
			System.out.println("Success!\n");
		}
		
	}
	
	

}
