package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.io.File;
import java.util.ArrayList;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.file.FileInfoBase;
import gov.nih.mipav.model.structures.ModelImage;

public class VolumeCollectionToCombinedSlabCollection extends ProcessingAlgorithm {

	//output params
	private ParamFileCollection outputFiles;	// Slabs

	//input params
	private ParamFileCollection inputFiles;		// Files to be split
	private ParamInteger numslabs;


	//Variables
	ArrayList<File> subVols;
	File outDir;
	CubicVolumeReaderWriter rw = CubicVolumeReaderWriter.getInstance();

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: VolumeCollectionToCombinedSlabCollection.java,v 1.1 2009/01/21 13:06:08 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setLabel("VolCollect to Combined4DSlabCollect");
		inputParams.setName("VolToCombined4DSlabs");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setPackage("Base");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu",""));
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));		
		info.setDescription("Converts a ");
		info.setAffiliation("Johns Hopkins University");		
		info.setVersion(revnum);	

		// Input Parameters
		inputParams.add(inputFiles= new ParamFileCollection("Input Volume Files",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));				
		inputParams.add(numslabs= new ParamInteger("Number of Slabs",1,100,4));
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outputFiles = new ParamFileCollection("Output Combined Slabs",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
	}

	@Override
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		outDir = this.getOutputDirectory();//MipavController.getDefaultWorkingDirectory();
		CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance();
		subVols = new ArrayList<File>();
		ImageData outputSlab;
		
		int lastSlabEndSlice=-1;
		for(int jSlab=0;jSlab<this.numslabs.getValue().intValue();jSlab++) {
			outputSlab = null;
			int startSlice=0, endSlice=0, nSlices;
			int jFile=0;
			for(File f: inputFiles.getValue()){
				ImageData vol = rw.read(f);
				if(outputSlab==null) {
					
					int totalSlices = vol.getSlices();
					int slicesPerSlab = (int)Math.ceil(totalSlices/(float)numslabs.getValue().intValue());
					startSlice = lastSlabEndSlice+1;
					endSlice = startSlice+slicesPerSlab-1;
					endSlice = (endSlice>=vol.getSlices()?vol.getSlices()-1:endSlice);
					lastSlabEndSlice=endSlice;
					nSlices = endSlice-startSlice+1;
					outputSlab = new ImageDataMipav(vol.getName()+"_Slab"+jSlab,
							vol.getRows(), vol.getCols(),nSlices,inputFiles.getValue().size());
					outputSlab.setHeader(vol.getHeader());
				}
				System.out.println("Slices: "+startSlice+"-"+endSlice);
				for(int i=0;i<vol.getRows();i++)
					for(int j=0;j<vol.getCols();j++) {
						int jSlice=0;					
						for(int k=startSlice;k<=endSlice;k++) {
							outputSlab.set(i,j,jSlice,jFile,vol.getFloat(i, j, k,0));
							jSlice++;
						}
					}
				vol.dispose();
				vol=null;						
				jFile++;
			}
			File target=rw.write(outputSlab, this.getOutputDirectory());
			outputSlab.dispose();
			outputSlab=null;
			subVols.add(target);
		}

		outputFiles.setValue(subVols);
	}
}
