package edu.jhu.cs.cisst.algorithms.geometry.surface;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

import javax.vecmath.Point3f;

import edu.jhu.cs.cisst.algorithms.segmentation.gac.GeodesicActiveContour3D;
import edu.jhu.cs.cisst.algorithms.segmentation.gac.GridPoint3D;
import edu.jhu.cs.cisst.algorithms.segmentation.gac.TopologyPreservationRule3D;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.geom.EmbeddedSurface;

public class IsoSurfaceGeneratorGAC extends IsoSurfaceGenerator {
	/**
	 * Instantiates a new iso surface generator.
	 */
	public IsoSurfaceGeneratorGAC() {
		super();
		setLabel("Iso-Surface");
	}

	public IsoSurfaceGeneratorGAC(TopologyPreservationRule3D.Rule rule) {
		super();
		this.connectivityRule = rule;
		setLabel("Iso-Surface");
	}

	public IsoSurfaceGeneratorGAC(AbstractCalculation parent,
			TopologyPreservationRule3D.Rule rule) {
		super(parent);
		this.connectivityRule = rule;
		setLabel("Iso-Surface");
	}

	/**
	 * Solve for iso-surface
	 * 
	 * @param vol
	 *            the volume
	 * @param isoLevel
	 *            the target iso-level
	 * 
	 * @return the iso-surface
	 */
	public EmbeddedSurface solve(GeodesicActiveContour3D gac) {
		vertCount = 0;
		this.isoLevel = 0;
		this.volMat = gac.getLevelSet().toArray3d();
		this.rows = volMat.length;
		this.cols = volMat[0].length;
		this.slices = volMat[0][0].length;
		Hashtable<Long, EdgeSplit> splits = new Hashtable<Long, EdgeSplit>();
		LinkedList<Triangle> triangles = new LinkedList<Triangle>();
		List<GridPoint3D> activePoints = gac.getActivePoints();
		List<GridPoint3D>[] insidePoints = gac.getInsidePoints();
		List<GridPoint3D>[] outsidePoints = gac.getOutsidePoints();
		if (!silent)
			setTotalUnits(activePoints.size() + insidePoints[0].size()
					+ insidePoints[1].size() + insidePoints[2].size()
					+ outsidePoints[0].size() + outsidePoints[1].size()
					+ outsidePoints[2].size());
		// Solve for iso-surface
		if (method == Method.MARCHING_CUBES || connectivityRule != null) {
			if (connectivityRule == null) {
				for (GridPoint3D gridPoint : activePoints) {
					triangulateUsingMarchingCubes(splits, triangles,
							gridPoint.x, gridPoint.y, gridPoint.z);
					if (!silent)
						incrementCompletedUnits();
				}
				for (int n = 0; n < 3; n++) {
					for (GridPoint3D gridPoint : insidePoints[n]) {
						triangulateUsingMarchingCubes(splits, triangles,
								gridPoint.x, gridPoint.y, gridPoint.z);
						if (!silent)
							incrementCompletedUnits();
					}
					for (GridPoint3D gridPoint : outsidePoints[n]) {
						triangulateUsingMarchingCubes(splits, triangles,
								gridPoint.x, gridPoint.y, gridPoint.z);
						if (!silent)
							incrementCompletedUnits();
					}
				}
			} else {
				for (GridPoint3D gridPoint : activePoints) {
					triangulateUsingMarchingCubesConnectivityConsistent(splits,
							triangles, gridPoint.x, gridPoint.y, gridPoint.z);
					if (!silent)
						incrementCompletedUnits();
				}
				for (int n = 0; n < 3; n++) {
					for (GridPoint3D gridPoint : insidePoints[n]) {
						triangulateUsingMarchingCubesConnectivityConsistent(
								splits, triangles, gridPoint.x, gridPoint.y,
								gridPoint.z);
						if (!silent)
							incrementCompletedUnits();
					}
					for (GridPoint3D gridPoint : outsidePoints[n]) {
						triangulateUsingMarchingCubesConnectivityConsistent(
								splits, triangles, gridPoint.x, gridPoint.y,
								gridPoint.z);
						if (!silent)
							incrementCompletedUnits();
					}
				}
			}
		} else if (method == Method.MARCHING_TETRAHEDRALS) {
			for (GridPoint3D gridPoint : activePoints) {
				triangulateUsingMarchingTetrahedrals(splits, triangles,
						gridPoint.x, gridPoint.y, gridPoint.z);
				if (!silent)
					incrementCompletedUnits();
			}
			for (int n = 0; n < 3; n++) {
				for (GridPoint3D gridPoint : insidePoints[n]) {
					triangulateUsingMarchingTetrahedrals(splits, triangles,
							gridPoint.x, gridPoint.y, gridPoint.z);
					if (!silent)
						incrementCompletedUnits();
				}
				for (GridPoint3D gridPoint : outsidePoints[n]) {
					triangulateUsingMarchingTetrahedrals(splits, triangles,
							gridPoint.x, gridPoint.y, gridPoint.z);
					if (!silent)
						incrementCompletedUnits();
				}
			}
		}
		// Generate iso-surface from list of triangles
		int[] indexes = new int[triangles.size() * 3];
		Point3f[] points = new Point3f[splits.size()];
		int index = 0;
		if (winding == Winding.CLOCKWISE) {
			for (Triangle tri : triangles) {
				indexes[index++] = tri.vids[0];
				indexes[index++] = tri.vids[1];
				indexes[index++] = tri.vids[2];
			}
		} else if (winding == Winding.COUNTER_CLOCKWISE) {
			for (Triangle tri : triangles) {
				indexes[index++] = tri.vids[2];
				indexes[index++] = tri.vids[1];
				indexes[index++] = tri.vids[0];
			}
		}
		index = 0;
		for (EdgeSplit split : splits.values()) {
			index = split.vid;
			points[index] = split.pt3d;
		}
		volMat = null;
		// Create surface
		EmbeddedSurface surf = new EmbeddedSurface(points, indexes);

		if (!silent)
			markCompleted();
		return surf;
	}
}
